/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.gasper.internal.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import pl.wavesoftware.eid.utils.EidPreconditions;

public class MavenResolver {
    public static final String DEFAULT_POM = "./pom.xml";
    public static final String DEFAULT_BUILD_DIR = "target";
    public static final String DEFAULT_PACKAGING = "jar";
    public static final String DEFAULT_CLASSIFIER = "";
    private static final Path CURRENT_DIR = Paths.get("./", new String[0]);
    private final Model model;
    private final Path pomDirectory;

    public MavenResolver() {
        this(DEFAULT_POM);
    }

    public MavenResolver(String pomfile) {
        this(Paths.get(pomfile, new String[0]));
    }

    public MavenResolver(Path pomfile) {
        EidPreconditions.checkArgument((Boolean)pomfile.toFile().isFile(), (String)"20160305:181005");
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        this.model = (Model)EidPreconditions.tryToExecute(() -> {
            FileInputStream is = new FileInputStream(pomfile.toFile());
            return mavenReader.read((InputStream)is);
        }, (String)"20160305:203232");
        ((Model)EidPreconditions.checkNotNull((Object)this.model, (String)"20160305:203551")).setPomFile(pomfile.toFile());
        this.pomDirectory = pomfile.getParent() == null ? CURRENT_DIR : pomfile.getParent();
        EidPreconditions.checkArgument((Boolean)this.pomDirectory.toFile().isDirectory(), (String)"20160305:181211");
    }

    public Path getBuildArtifact() {
        return this.getBuildArtifact(DEFAULT_CLASSIFIER, DEFAULT_CLASSIFIER);
    }

    public Path getBuildArtifact(String classifier) {
        return this.getBuildArtifact(DEFAULT_CLASSIFIER, classifier);
    }

    public Path getBuildArtifact(String packaging, String classifier) {
        Path dir = this.getBuildDirectory().toPath();
        String pack = Objects.equals(packaging, DEFAULT_CLASSIFIER) ? this.getModelPackaging() : packaging;
        String artifact = Objects.equals(classifier, DEFAULT_CLASSIFIER) ? String.format("%s-%s.%s", this.model.getArtifactId(), this.model.getVersion(), pack) : String.format("%s-%s-%s.%s", this.model.getArtifactId(), this.model.getVersion(), classifier, pack);
        Path artifactPath = dir.resolve(Paths.get(artifact, new String[0]));
        EidPreconditions.checkState((Boolean)artifactPath.toFile().isFile(), (String)"20160305:181432", (String)"Is not a file: %s", (Object[])new Object[]{artifactPath});
        EidPreconditions.checkState((Boolean)artifactPath.toFile().canRead(), (String)"20160305:181456", (String)"Can't read file: %s", (Object[])new Object[]{artifactPath});
        return artifactPath;
    }

    public File getBuildDirectory() {
        String set = this.model.getBuild().getOutputDirectory();
        Path directory = this.pomDirectory.resolve(Paths.get(set == null ? DEFAULT_BUILD_DIR : set, new String[0]));
        EidPreconditions.checkState((Boolean)directory.toFile().isDirectory(), (String)"20160304:230811");
        return directory.normalize().toFile();
    }

    public String getModelPackaging() {
        return this.model.getPackaging() == null ? DEFAULT_PACKAGING : this.model.getPackaging();
    }
}

