/*
 * Decompiled with CFR 0.152.
 */
package pl.wendigo.chrome;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.wendigo.chrome.ChromeDebuggerConnection;
import pl.wendigo.chrome.DebuggerProtocol;
import pl.wendigo.chrome.FrameMapper;
import pl.wendigo.chrome.FramesStream;
import pl.wendigo.chrome.ProtocolEvent;
import pl.wendigo.chrome.RequestFailed;
import pl.wendigo.chrome.RequestFrame;
import pl.wendigo.chrome.ResponseFrame;
import pl.wendigo.chrome.WebsocketFramesStream;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\u000f\"\b\b\u0000\u0010\u0011*\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\nH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0016\u001a\u00020\u00152\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\u0018H\u0016J4\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001a\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00110\nH\u0016R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lpl/wendigo/chrome/ChromeDebuggerConnection;", "Lpl/wendigo/chrome/DebuggerProtocol;", "frames", "Lpl/wendigo/chrome/FramesStream;", "mapper", "Lpl/wendigo/chrome/FrameMapper;", "(Lpl/wendigo/chrome/FramesStream;Lpl/wendigo/chrome/FrameMapper;)V", "eventNameToClassMapping", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/lang/Class;", "Lpl/wendigo/chrome/ProtocolEvent;", "nextRequestId", "Ljava/util/concurrent/atomic/AtomicLong;", "captureAllEvents", "Lio/reactivex/Flowable;", "captureEvents", "T", "name", "outClazz", "close", "", "registerEventMappings", "mapOf", "", "runAndCaptureResponse", "Lio/reactivex/Single;", "params", "", "clazz", "Companion", "chrome-reactive-kotlin_main"})
public final class ChromeDebuggerConnection
implements DebuggerProtocol {
    private final ConcurrentHashMap<String, Class<? extends ProtocolEvent>> eventNameToClassMapping;
    private final AtomicLong nextRequestId;
    private final FramesStream frames;
    private final FrameMapper mapper;
    public static final Companion Companion = new Companion(null);

    @Override
    public void registerEventMappings(@NotNull Map<String, ? extends Class<? extends ProtocolEvent>> mapOf) {
        Intrinsics.checkParameterIsNotNull(mapOf, (String)"mapOf");
        this.eventNameToClassMapping.putAll(mapOf);
    }

    @Override
    public void close() {
        this.frames.close();
    }

    @Override
    @NotNull
    public <T> Single<T> runAndCaptureResponse(@NotNull String name, @Nullable Object params, @NotNull Class<T> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Single single = Single.fromCallable((Callable)new Callable<T>(this, name, params){
            final /* synthetic */ ChromeDebuggerConnection this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Object $params;

            @NotNull
            public final RequestFrame call() {
                return new RequestFrame(ChromeDebuggerConnection.access$getNextRequestId$p(this.this$0).incrementAndGet(), this.$name, this.$params);
            }
            {
                this.this$0 = chromeDebuggerConnection;
                this.$name = string;
                this.$params = object;
            }
        }).flatMap(new Function<T, SingleSource<? extends R>>(this, clazz){
            final /* synthetic */ ChromeDebuggerConnection this$0;
            final /* synthetic */ Class $clazz;

            public final Single<T> apply(RequestFrame request) {
                FramesStream framesStream = ChromeDebuggerConnection.access$getFrames$p(this.this$0);
                RequestFrame requestFrame = request;
                Intrinsics.checkExpressionValueIsNotNull((Object)requestFrame, (String)"request");
                return framesStream.send(requestFrame).flatMap((Function)new Function<T, SingleSource<? extends R>>(this, request){
                    final /* synthetic */ runAndCaptureResponse.2 this$0;
                    final /* synthetic */ RequestFrame $request;

                    @NotNull
                    public final Single<T> apply(Boolean result) {
                        Single<T> single;
                        if (Intrinsics.areEqual((Object)result, (Object)true)) {
                            FramesStream framesStream = ChromeDebuggerConnection.access$getFrames$p(this.this$0.this$0);
                            RequestFrame requestFrame = this.$request;
                            Intrinsics.checkExpressionValueIsNotNull((Object)requestFrame, (String)"request");
                            single = framesStream.getResponse(requestFrame, this.this$0.$clazz);
                        } else {
                            RequestFrame requestFrame = this.$request;
                            Intrinsics.checkExpressionValueIsNotNull((Object)requestFrame, (String)"request");
                            Single<T> single2 = Single.error((Throwable)new RequestFailed(requestFrame, "Could not enqueue message"));
                            single = single2;
                            Intrinsics.checkExpressionValueIsNotNull(single2, (String)"Single.error(RequestFail\u2026ld not enqueue message\"))");
                        }
                        return single;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$request = requestFrame;
                    }
                });
            }
            {
                this.this$0 = chromeDebuggerConnection;
                this.$clazz = clazz;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromCallable {\n  \u2026}\n            }\n        }");
        return single;
    }

    @Override
    @NotNull
    public <T extends ProtocolEvent> Flowable<T> captureEvents(@NotNull String name, @NotNull Class<T> outClazz) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(outClazz, (String)"outClazz");
        Flowable flowable = this.frames.eventFrames().filter((Predicate)new Predicate<ResponseFrame>(name){
            final /* synthetic */ String $name;

            public final boolean test(ResponseFrame frame) {
                return Intrinsics.areEqual((Object)frame.getMethod(), (Object)this.$name);
            }
            {
                this.$name = string;
            }
        }).flatMapSingle(new Function<T, SingleSource<? extends R>>(this, outClazz){
            final /* synthetic */ ChromeDebuggerConnection this$0;
            final /* synthetic */ Class $outClazz;

            @NotNull
            public final Single<T> apply(ResponseFrame frame) {
                FrameMapper frameMapper = ChromeDebuggerConnection.access$getMapper$p(this.this$0);
                ResponseFrame responseFrame = frame;
                Intrinsics.checkExpressionValueIsNotNull((Object)responseFrame, (String)"frame");
                return frameMapper.deserializeEvent$chrome_reactive_kotlin_main(responseFrame, this.$outClazz);
            }
            {
                this.this$0 = chromeDebuggerConnection;
                this.$outClazz = clazz;
            }
        }).subscribeOn(Schedulers.io()).toFlowable(BackpressureStrategy.BUFFER);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"frames.eventFrames()\n   \u2026kpressureStrategy.BUFFER)");
        return flowable;
    }

    @Override
    @NotNull
    public Flowable<ProtocolEvent> captureAllEvents() {
        Flowable flowable = this.frames.eventFrames().flatMapSingle(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ ChromeDebuggerConnection this$0;

            @NotNull
            public final Single<? extends ProtocolEvent> apply(ResponseFrame frame) {
                FrameMapper frameMapper = ChromeDebuggerConnection.access$getMapper$p(this.this$0);
                ResponseFrame responseFrame = frame;
                Intrinsics.checkExpressionValueIsNotNull((Object)responseFrame, (String)"frame");
                Map map = ChromeDebuggerConnection.access$getEventNameToClassMapping$p(this.this$0);
                String string = frame.getMethod();
                ResponseFrame responseFrame2 = responseFrame;
                FrameMapper frameMapper2 = frameMapper;
                Map map2 = map;
                if (map2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                V v = map2.get(string);
                Class<ProtocolEvent> clazz = (Class<ProtocolEvent>)v;
                if (clazz == null) {
                    clazz = ProtocolEvent.class;
                }
                return frameMapper2.deserializeEvent$chrome_reactive_kotlin_main(responseFrame2, clazz);
            }
            {
                this.this$0 = chromeDebuggerConnection;
            }
        }).subscribeOn(Schedulers.io()).toFlowable(BackpressureStrategy.LATEST);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"frames.eventFrames()\n   \u2026kpressureStrategy.LATEST)");
        return flowable;
    }

    public ChromeDebuggerConnection(@NotNull FramesStream frames2, @NotNull FrameMapper mapper) {
        Intrinsics.checkParameterIsNotNull((Object)frames2, (String)"frames");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        this.frames = frames2;
        this.mapper = mapper;
        this.eventNameToClassMapping = new ConcurrentHashMap();
        this.nextRequestId = new AtomicLong(0L);
    }

    @NotNull
    public static final /* synthetic */ AtomicLong access$getNextRequestId$p(ChromeDebuggerConnection $this) {
        return $this.nextRequestId;
    }

    @NotNull
    public static final /* synthetic */ FramesStream access$getFrames$p(ChromeDebuggerConnection $this) {
        return $this.frames;
    }

    @NotNull
    public static final /* synthetic */ FrameMapper access$getMapper$p(ChromeDebuggerConnection $this) {
        return $this.mapper;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getEventNameToClassMapping$p(ChromeDebuggerConnection $this) {
        return $this.eventNameToClassMapping;
    }

    @JvmStatic
    @NotNull
    public static final ChromeDebuggerConnection openSession(@NotNull String url, int eventBufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        return Companion.openSession(url, eventBufferSize);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lpl/wendigo/chrome/ChromeDebuggerConnection$Companion;", "", "()V", "openSession", "Lpl/wendigo/chrome/ChromeDebuggerConnection;", "url", "", "eventBufferSize", "", "chrome-reactive-kotlin_main"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ChromeDebuggerConnection openSession(@NotNull String url, int eventBufferSize) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            FrameMapper mapper = new FrameMapper();
            ReplaySubject replaySubject = ReplaySubject.create((int)eventBufferSize);
            Intrinsics.checkExpressionValueIsNotNull((Object)replaySubject, (String)"ReplaySubject.create(eventBufferSize)");
            WebsocketFramesStream frames2 = new WebsocketFramesStream(url, (Subject<ResponseFrame>)((Subject)replaySubject), mapper, new OkHttpClient());
            return new ChromeDebuggerConnection(frames2, mapper);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ ChromeDebuggerConnection openSession$default(Companion companion, String string, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 128;
            }
            return companion.openSession(string, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

