/*
 * Decompiled with CFR 0.152.
 */
package pl.wendigo.chrome.domain.debugger;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.wendigo.chrome.DebuggerProtocol;
import pl.wendigo.chrome.Experimental;
import pl.wendigo.chrome.ProtocolEvent;
import pl.wendigo.chrome.ResponseFrame;
import pl.wendigo.chrome.domain.debugger.BreakpointResolvedEvent;
import pl.wendigo.chrome.domain.debugger.ContinueToLocationRequest;
import pl.wendigo.chrome.domain.debugger.DebuggerDomain;
import pl.wendigo.chrome.domain.debugger.EvaluateOnCallFrameRequest;
import pl.wendigo.chrome.domain.debugger.EvaluateOnCallFrameResponse;
import pl.wendigo.chrome.domain.debugger.GetPossibleBreakpointsRequest;
import pl.wendigo.chrome.domain.debugger.GetPossibleBreakpointsResponse;
import pl.wendigo.chrome.domain.debugger.GetScriptSourceRequest;
import pl.wendigo.chrome.domain.debugger.GetScriptSourceResponse;
import pl.wendigo.chrome.domain.debugger.PausedEvent;
import pl.wendigo.chrome.domain.debugger.RemoveBreakpointRequest;
import pl.wendigo.chrome.domain.debugger.RestartFrameRequest;
import pl.wendigo.chrome.domain.debugger.RestartFrameResponse;
import pl.wendigo.chrome.domain.debugger.ScriptFailedToParseEvent;
import pl.wendigo.chrome.domain.debugger.ScriptParsedEvent;
import pl.wendigo.chrome.domain.debugger.SearchInContentRequest;
import pl.wendigo.chrome.domain.debugger.SearchInContentResponse;
import pl.wendigo.chrome.domain.debugger.SetAsyncCallStackDepthRequest;
import pl.wendigo.chrome.domain.debugger.SetBlackboxPatternsRequest;
import pl.wendigo.chrome.domain.debugger.SetBlackboxedRangesRequest;
import pl.wendigo.chrome.domain.debugger.SetBreakpointByUrlRequest;
import pl.wendigo.chrome.domain.debugger.SetBreakpointByUrlResponse;
import pl.wendigo.chrome.domain.debugger.SetBreakpointRequest;
import pl.wendigo.chrome.domain.debugger.SetBreakpointResponse;
import pl.wendigo.chrome.domain.debugger.SetBreakpointsActiveRequest;
import pl.wendigo.chrome.domain.debugger.SetPauseOnExceptionsRequest;
import pl.wendigo.chrome.domain.debugger.SetScriptSourceRequest;
import pl.wendigo.chrome.domain.debugger.SetScriptSourceResponse;
import pl.wendigo.chrome.domain.debugger.SetSkipAllPausesRequest;
import pl.wendigo.chrome.domain.debugger.SetVariableValueRequest;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\u000b\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\t2\u0006\u0010\u000b\u001a\u00020\u0016H\u0007J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\u000b\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0006J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\t2\u0006\u0010\u000b\u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0006J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0006J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\t2\u0006\u0010\u000b\u001a\u00020+H\u0007J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020-J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020/H\u0007J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u000201H\u0007J\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\t2\u0006\u0010\u000b\u001a\u000204J\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060\t2\u0006\u0010\u000b\u001a\u000207J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u000209J\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020;J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\t2\u0006\u0010\u000b\u001a\u00020>J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020@J\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020BJ\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lpl/wendigo/chrome/domain/debugger/DebuggerDomain;", "", "connectionRemote", "Lpl/wendigo/chrome/DebuggerProtocol;", "(Lpl/wendigo/chrome/DebuggerProtocol;)V", "breakpointResolved", "Lio/reactivex/Flowable;", "Lpl/wendigo/chrome/domain/debugger/BreakpointResolvedEvent;", "continueToLocation", "Lio/reactivex/Single;", "Lpl/wendigo/chrome/ResponseFrame;", "input", "Lpl/wendigo/chrome/domain/debugger/ContinueToLocationRequest;", "disable", "enable", "evaluateOnCallFrame", "Lpl/wendigo/chrome/domain/debugger/EvaluateOnCallFrameResponse;", "Lpl/wendigo/chrome/domain/debugger/EvaluateOnCallFrameRequest;", "events", "Lpl/wendigo/chrome/ProtocolEvent;", "getPossibleBreakpoints", "Lpl/wendigo/chrome/domain/debugger/GetPossibleBreakpointsResponse;", "Lpl/wendigo/chrome/domain/debugger/GetPossibleBreakpointsRequest;", "getScriptSource", "Lpl/wendigo/chrome/domain/debugger/GetScriptSourceResponse;", "Lpl/wendigo/chrome/domain/debugger/GetScriptSourceRequest;", "pause", "paused", "Lpl/wendigo/chrome/domain/debugger/PausedEvent;", "removeBreakpoint", "Lpl/wendigo/chrome/domain/debugger/RemoveBreakpointRequest;", "restartFrame", "Lpl/wendigo/chrome/domain/debugger/RestartFrameResponse;", "Lpl/wendigo/chrome/domain/debugger/RestartFrameRequest;", "resume", "resumed", "scheduleStepIntoAsync", "scriptFailedToParse", "Lpl/wendigo/chrome/domain/debugger/ScriptFailedToParseEvent;", "scriptParsed", "Lpl/wendigo/chrome/domain/debugger/ScriptParsedEvent;", "searchInContent", "Lpl/wendigo/chrome/domain/debugger/SearchInContentResponse;", "Lpl/wendigo/chrome/domain/debugger/SearchInContentRequest;", "setAsyncCallStackDepth", "Lpl/wendigo/chrome/domain/debugger/SetAsyncCallStackDepthRequest;", "setBlackboxPatterns", "Lpl/wendigo/chrome/domain/debugger/SetBlackboxPatternsRequest;", "setBlackboxedRanges", "Lpl/wendigo/chrome/domain/debugger/SetBlackboxedRangesRequest;", "setBreakpoint", "Lpl/wendigo/chrome/domain/debugger/SetBreakpointResponse;", "Lpl/wendigo/chrome/domain/debugger/SetBreakpointRequest;", "setBreakpointByUrl", "Lpl/wendigo/chrome/domain/debugger/SetBreakpointByUrlResponse;", "Lpl/wendigo/chrome/domain/debugger/SetBreakpointByUrlRequest;", "setBreakpointsActive", "Lpl/wendigo/chrome/domain/debugger/SetBreakpointsActiveRequest;", "setPauseOnExceptions", "Lpl/wendigo/chrome/domain/debugger/SetPauseOnExceptionsRequest;", "setScriptSource", "Lpl/wendigo/chrome/domain/debugger/SetScriptSourceResponse;", "Lpl/wendigo/chrome/domain/debugger/SetScriptSourceRequest;", "setSkipAllPauses", "Lpl/wendigo/chrome/domain/debugger/SetSkipAllPausesRequest;", "setVariableValue", "Lpl/wendigo/chrome/domain/debugger/SetVariableValueRequest;", "stepInto", "stepOut", "stepOver", "chrome-reactive-kotlin_main"})
public final class DebuggerDomain {
    private final DebuggerProtocol connectionRemote;

    @NotNull
    public final Single<ResponseFrame> enable() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.enable", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> disable() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.disable", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> setBreakpointsActive(@NotNull SetBreakpointsActiveRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setBreakpointsActive", input, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> setSkipAllPauses(@NotNull SetSkipAllPausesRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setSkipAllPauses", input, ResponseFrame.class);
    }

    @NotNull
    public final Single<SetBreakpointByUrlResponse> setBreakpointByUrl(@NotNull SetBreakpointByUrlRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setBreakpointByUrl", input, SetBreakpointByUrlResponse.class);
    }

    @NotNull
    public final Single<SetBreakpointResponse> setBreakpoint(@NotNull SetBreakpointRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setBreakpoint", input, SetBreakpointResponse.class);
    }

    @NotNull
    public final Single<ResponseFrame> removeBreakpoint(@NotNull RemoveBreakpointRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.removeBreakpoint", input, ResponseFrame.class);
    }

    @Experimental
    @NotNull
    public final Single<GetPossibleBreakpointsResponse> getPossibleBreakpoints(@NotNull GetPossibleBreakpointsRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.getPossibleBreakpoints", input, GetPossibleBreakpointsResponse.class);
    }

    @NotNull
    public final Single<ResponseFrame> continueToLocation(@NotNull ContinueToLocationRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.continueToLocation", input, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> stepOver() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.stepOver", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> stepInto() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.stepInto", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> stepOut() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.stepOut", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> pause() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.pause", null, ResponseFrame.class);
    }

    @Experimental
    @NotNull
    public final Single<ResponseFrame> scheduleStepIntoAsync() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.scheduleStepIntoAsync", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> resume() {
        return this.connectionRemote.runAndCaptureResponse("Debugger.resume", null, ResponseFrame.class);
    }

    @Experimental
    @NotNull
    public final Single<SearchInContentResponse> searchInContent(@NotNull SearchInContentRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.searchInContent", input, SearchInContentResponse.class);
    }

    @NotNull
    public final Single<SetScriptSourceResponse> setScriptSource(@NotNull SetScriptSourceRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setScriptSource", input, SetScriptSourceResponse.class);
    }

    @NotNull
    public final Single<RestartFrameResponse> restartFrame(@NotNull RestartFrameRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.restartFrame", input, RestartFrameResponse.class);
    }

    @NotNull
    public final Single<GetScriptSourceResponse> getScriptSource(@NotNull GetScriptSourceRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.getScriptSource", input, GetScriptSourceResponse.class);
    }

    @NotNull
    public final Single<ResponseFrame> setPauseOnExceptions(@NotNull SetPauseOnExceptionsRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setPauseOnExceptions", input, ResponseFrame.class);
    }

    @NotNull
    public final Single<EvaluateOnCallFrameResponse> evaluateOnCallFrame(@NotNull EvaluateOnCallFrameRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.evaluateOnCallFrame", input, EvaluateOnCallFrameResponse.class);
    }

    @NotNull
    public final Single<ResponseFrame> setVariableValue(@NotNull SetVariableValueRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setVariableValue", input, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> setAsyncCallStackDepth(@NotNull SetAsyncCallStackDepthRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setAsyncCallStackDepth", input, ResponseFrame.class);
    }

    @Experimental
    @NotNull
    public final Single<ResponseFrame> setBlackboxPatterns(@NotNull SetBlackboxPatternsRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setBlackboxPatterns", input, ResponseFrame.class);
    }

    @Experimental
    @NotNull
    public final Single<ResponseFrame> setBlackboxedRanges(@NotNull SetBlackboxedRangesRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Debugger.setBlackboxedRanges", input, ResponseFrame.class);
    }

    @NotNull
    public final Flowable<ScriptParsedEvent> scriptParsed() {
        return this.connectionRemote.captureEvents("Debugger.scriptParsed", ScriptParsedEvent.class);
    }

    @NotNull
    public final Flowable<ScriptFailedToParseEvent> scriptFailedToParse() {
        return this.connectionRemote.captureEvents("Debugger.scriptFailedToParse", ScriptFailedToParseEvent.class);
    }

    @NotNull
    public final Flowable<BreakpointResolvedEvent> breakpointResolved() {
        return this.connectionRemote.captureEvents("Debugger.breakpointResolved", BreakpointResolvedEvent.class);
    }

    @NotNull
    public final Flowable<PausedEvent> paused() {
        return this.connectionRemote.captureEvents("Debugger.paused", PausedEvent.class);
    }

    @NotNull
    public final Flowable<ProtocolEvent> resumed() {
        return this.connectionRemote.captureEvents("Debugger.resumed", ProtocolEvent.class);
    }

    @NotNull
    public final Flowable<ProtocolEvent> events() {
        Flowable flowable = this.connectionRemote.captureAllEvents().filter((Predicate)events.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"connectionRemote.capture\u2026) == \"Debugger\"\n        }");
        return flowable;
    }

    public DebuggerDomain(@NotNull DebuggerProtocol connectionRemote) {
        Intrinsics.checkParameterIsNotNull((Object)connectionRemote, (String)"connectionRemote");
        this.connectionRemote = connectionRemote;
    }
}

