/*
 * Decompiled with CFR 0.152.
 */
package pl.wendigo.chrome.domain.tracing;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.wendigo.chrome.DebuggerProtocol;
import pl.wendigo.chrome.Experimental;
import pl.wendigo.chrome.ProtocolEvent;
import pl.wendigo.chrome.ResponseFrame;
import pl.wendigo.chrome.domain.tracing.BufferUsageEvent;
import pl.wendigo.chrome.domain.tracing.DataCollectedEvent;
import pl.wendigo.chrome.domain.tracing.GetCategoriesResponse;
import pl.wendigo.chrome.domain.tracing.RecordClockSyncMarkerRequest;
import pl.wendigo.chrome.domain.tracing.RequestMemoryDumpResponse;
import pl.wendigo.chrome.domain.tracing.StartRequest;
import pl.wendigo.chrome.domain.tracing.TracingCompleteEvent;
import pl.wendigo.chrome.domain.tracing.TracingDomain;

@Experimental
@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/wendigo/chrome/domain/tracing/TracingDomain;", "", "connectionRemote", "Lpl/wendigo/chrome/DebuggerProtocol;", "(Lpl/wendigo/chrome/DebuggerProtocol;)V", "bufferUsage", "Lio/reactivex/Flowable;", "Lpl/wendigo/chrome/domain/tracing/BufferUsageEvent;", "dataCollected", "Lpl/wendigo/chrome/domain/tracing/DataCollectedEvent;", "end", "Lio/reactivex/Single;", "Lpl/wendigo/chrome/ResponseFrame;", "events", "Lpl/wendigo/chrome/ProtocolEvent;", "getCategories", "Lpl/wendigo/chrome/domain/tracing/GetCategoriesResponse;", "recordClockSyncMarker", "input", "Lpl/wendigo/chrome/domain/tracing/RecordClockSyncMarkerRequest;", "requestMemoryDump", "Lpl/wendigo/chrome/domain/tracing/RequestMemoryDumpResponse;", "start", "Lpl/wendigo/chrome/domain/tracing/StartRequest;", "tracingComplete", "Lpl/wendigo/chrome/domain/tracing/TracingCompleteEvent;", "chrome-reactive-kotlin_main"})
public final class TracingDomain {
    private final DebuggerProtocol connectionRemote;

    @NotNull
    public final Single<ResponseFrame> start(@NotNull StartRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Tracing.start", input, ResponseFrame.class);
    }

    @NotNull
    public final Single<ResponseFrame> end() {
        return this.connectionRemote.runAndCaptureResponse("Tracing.end", null, ResponseFrame.class);
    }

    @NotNull
    public final Single<GetCategoriesResponse> getCategories() {
        return this.connectionRemote.runAndCaptureResponse("Tracing.getCategories", null, GetCategoriesResponse.class);
    }

    @NotNull
    public final Single<RequestMemoryDumpResponse> requestMemoryDump() {
        return this.connectionRemote.runAndCaptureResponse("Tracing.requestMemoryDump", null, RequestMemoryDumpResponse.class);
    }

    @NotNull
    public final Single<ResponseFrame> recordClockSyncMarker(@NotNull RecordClockSyncMarkerRequest input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.connectionRemote.runAndCaptureResponse("Tracing.recordClockSyncMarker", input, ResponseFrame.class);
    }

    @NotNull
    public final Flowable<DataCollectedEvent> dataCollected() {
        return this.connectionRemote.captureEvents("Tracing.dataCollected", DataCollectedEvent.class);
    }

    @NotNull
    public final Flowable<TracingCompleteEvent> tracingComplete() {
        return this.connectionRemote.captureEvents("Tracing.tracingComplete", TracingCompleteEvent.class);
    }

    @NotNull
    public final Flowable<BufferUsageEvent> bufferUsage() {
        return this.connectionRemote.captureEvents("Tracing.bufferUsage", BufferUsageEvent.class);
    }

    @NotNull
    public final Flowable<ProtocolEvent> events() {
        Flowable flowable = this.connectionRemote.captureAllEvents().filter((Predicate)events.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"connectionRemote.capture\u2026() == \"Tracing\"\n        }");
        return flowable;
    }

    public TracingDomain(@NotNull DebuggerProtocol connectionRemote) {
        Intrinsics.checkParameterIsNotNull((Object)connectionRemote, (String)"connectionRemote");
        this.connectionRemote = connectionRemote;
    }
}

