/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.cform.devicefarm.project.service;

import com.amazonaws.services.devicefarm.AWSDeviceFarm;
import com.amazonaws.services.devicefarm.model.CreateTestGridProjectRequest;
import com.amazonaws.services.devicefarm.model.DeleteTestGridProjectRequest;
import com.amazonaws.services.devicefarm.model.TestGridProject;
import com.amazonaws.services.devicefarm.model.UpdateTestGridProjectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.CustomResourceResponse;
import pl.wrzasq.lambda.cform.devicefarm.project.model.DeviceFarmProjectRequest;

public class DeviceFarmProjectManager {
    private Logger logger = LoggerFactory.getLogger(DeviceFarmProjectManager.class);
    private AWSDeviceFarm deviceFarm;

    public DeviceFarmProjectManager(AWSDeviceFarm deviceFarm) {
        this.deviceFarm = deviceFarm;
    }

    public CustomResourceResponse<TestGridProject> create(DeviceFarmProjectRequest input, String physicalResourceId) {
        TestGridProject project = this.deviceFarm.createTestGridProject(new CreateTestGridProjectRequest().withName(input.getName()).withDescription(input.getDescription())).getTestGridProject();
        return new CustomResourceResponse((Object)project, project.getArn());
    }

    public CustomResourceResponse<TestGridProject> update(DeviceFarmProjectRequest input, String physicalResourceId) {
        TestGridProject project = this.deviceFarm.updateTestGridProject(new UpdateTestGridProjectRequest().withProjectArn(physicalResourceId).withName(input.getName()).withDescription(input.getDescription())).getTestGridProject();
        return new CustomResourceResponse((Object)project, project.getArn());
    }

    public CustomResourceResponse<TestGridProject> delete(DeviceFarmProjectRequest input, String physicalResourceId) {
        this.deviceFarm.deleteTestGridProject(new DeleteTestGridProjectRequest().withProjectArn(physicalResourceId));
        this.logger.info("Project deleted.");
        return new CustomResourceResponse(null, physicalResourceId);
    }
}

