/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.cform.passwordpolicy.service;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.CustomResourceResponse;

public class PasswordPolicyManager {
    private static final String PHYSICAL_RESOURCE_ID = "password-policy";
    private Logger logger = LoggerFactory.getLogger(PasswordPolicyManager.class);
    private AmazonIdentityManagement iam;

    public PasswordPolicyManager(AmazonIdentityManagement iam) {
        this.iam = iam;
    }

    public CustomResourceResponse<UpdateAccountPasswordPolicyRequest> setPolicy(UpdateAccountPasswordPolicyRequest input, String physicalResourceId) {
        this.iam.updateAccountPasswordPolicy(input);
        this.logger.info("Account password policy set.");
        return new CustomResourceResponse((Object)input, physicalResourceId == null ? PHYSICAL_RESOURCE_ID : physicalResourceId);
    }

    public CustomResourceResponse<UpdateAccountPasswordPolicyRequest> delete(UpdateAccountPasswordPolicyRequest input, String physicalResourceId) {
        this.iam.deleteAccountPasswordPolicy();
        this.logger.info("Account password policy removed.");
        return new CustomResourceResponse(null, physicalResourceId);
    }
}

