/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreateTopicRequestMarshaller
implements Marshaller<Request<CreateTopicRequest>, CreateTopicRequest> {
    @Override
    public Request<CreateTopicRequest> marshall(CreateTopicRequest createTopicRequest) {
        if (createTopicRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTopicRequest> request = new DefaultRequest<CreateTopicRequest>(createTopicRequest, "AmazonSNS");
        request.addParameter("Action", "CreateTopic");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTopicRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createTopicRequest.getName()));
        }
        Map<String, String> attributes = createTopicRequest.getAttributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString(entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString(entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

