/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.contexts.SegmentContextResolverChain;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.plugins.Plugin;
import com.amazonaws.xray.strategy.ContextMissingStrategy;
import com.amazonaws.xray.strategy.LogErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.PrioritizationStrategy;
import com.amazonaws.xray.strategy.RuntimeErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.StreamingStrategy;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayRecorderBuilder {
    private static final Log logger = LogFactory.getLog(AWSXRayRecorderBuilder.class);
    private Collection<Plugin> plugins = new ArrayList<Plugin>();
    private SamplingStrategy samplingStrategy;
    private StreamingStrategy streamingStrategy;
    private PrioritizationStrategy prioritizationStrategy;
    private ThrowableSerializationStrategy throwableSerializationStrategy;
    private ContextMissingStrategy contextMissingStrategy;
    private SegmentContextResolverChain segmentContextResolverChain;
    private Emitter emitter;

    private AWSXRayRecorderBuilder() {
    }

    public static Optional<ContextMissingStrategy> contextMissingStrategyFromEnvironmentVariable() {
        String contextMissingStrategyOverrideValue = System.getenv("AWS_XRAY_CONTEXT_MISSING");
        if (null != contextMissingStrategyOverrideValue) {
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("LOG_ERROR")) {
                return Optional.of(new LogErrorContextMissingStrategy());
            }
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("RUNTIME_ERROR")) {
                return Optional.of(new RuntimeErrorContextMissingStrategy());
            }
        }
        return Optional.empty();
    }

    public static Optional<ContextMissingStrategy> contextMissingStrategyFromSystemProperty() {
        String contextMissingStrategyOverrideValue = System.getProperty("com.amazonaws.xray.strategy.contextMissingStrategy");
        if (null != contextMissingStrategyOverrideValue) {
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("LOG_ERROR")) {
                return Optional.of(new LogErrorContextMissingStrategy());
            }
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("RUNTIME_ERROR")) {
                return Optional.of(new RuntimeErrorContextMissingStrategy());
            }
        }
        return Optional.empty();
    }

    public static AWSXRayRecorderBuilder standard() {
        return new AWSXRayRecorderBuilder();
    }

    public static AWSXRayRecorder defaultRecorder() {
        return AWSXRayRecorderBuilder.standard().build();
    }

    public AWSXRayRecorderBuilder withPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public AWSXRayRecorderBuilder withSamplingStrategy(SamplingStrategy samplingStrategy) {
        this.samplingStrategy = samplingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withPrioritizationStrategy(PrioritizationStrategy prioritizationStrategy) {
        this.prioritizationStrategy = prioritizationStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withThrowableSerializationStrategy(ThrowableSerializationStrategy throwableSerializationStrategy) {
        this.throwableSerializationStrategy = throwableSerializationStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withEmitter(Emitter emitter) {
        this.emitter = emitter;
        return this;
    }

    public AWSXRayRecorderBuilder withSegmentContextResolverChain(SegmentContextResolverChain segmentContextResolverChain) {
        this.segmentContextResolverChain = segmentContextResolverChain;
        return this;
    }

    public AWSXRayRecorderBuilder withContextMissingStrategy(ContextMissingStrategy contextMissingStrategy) {
        this.contextMissingStrategy = contextMissingStrategy;
        return this;
    }

    public AWSXRayRecorder build() {
        AWSXRayRecorder client = new AWSXRayRecorder();
        if (null != this.samplingStrategy) {
            client.setSamplingStrategy(this.samplingStrategy);
        }
        if (null != this.streamingStrategy) {
            client.setStreamingStrategy(this.streamingStrategy);
        }
        if (null != this.prioritizationStrategy) {
            client.setPrioritizationStrategy(this.prioritizationStrategy);
        }
        if (null != this.throwableSerializationStrategy) {
            client.setThrowableSerializationStrategy(this.throwableSerializationStrategy);
        }
        if (null != this.contextMissingStrategy && !AWSXRayRecorderBuilder.contextMissingStrategyFromEnvironmentVariable().isPresent() && !AWSXRayRecorderBuilder.contextMissingStrategyFromSystemProperty().isPresent()) {
            client.setContextMissingStrategy(this.contextMissingStrategy);
        }
        if (null != this.segmentContextResolverChain) {
            client.setSegmentContextResolverChain(this.segmentContextResolverChain);
        }
        if (null != this.emitter) {
            client.setEmitter(this.emitter);
        }
        this.plugins.stream().filter(Objects::nonNull).forEach(plugin -> {
            Map<String, Object> runtimeContext = plugin.getRuntimeContext();
            if (!runtimeContext.isEmpty()) {
                client.putRuntimeContext(plugin.getServiceName(), runtimeContext);
                client.setOrigin(plugin.getOrigin());
            } else {
                logger.warn(plugin.getClass().getName() + " plugin returned empty runtime context data. The recorder will not be setting segment origin or runtime context values from this plugin.");
            }
        });
        return client;
    }
}

