/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.contexts;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.contexts.SegmentContext;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.FacadeSegment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.SubsegmentImpl;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.exceptions.SubsegmentNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LambdaSegmentContext
implements SegmentContext {
    private static final Log logger = LogFactory.getLog(LambdaSegmentContext.class);
    private static final String LAMBDA_TRACE_HEADER_KEY = "_X_AMZN_TRACE_ID";

    private static TraceHeader getTraceHeaderFromEnvironment() {
        return TraceHeader.fromString(System.getenv(LAMBDA_TRACE_HEADER_KEY));
    }

    private static boolean isInitializing(TraceHeader traceHeader) {
        return null == traceHeader.getRootTraceId() || null == traceHeader.getSampled() || null == traceHeader.getParentId();
    }

    private static FacadeSegment newFacadeSegment(AWSXRayRecorder recorder) {
        TraceHeader traceHeader = LambdaSegmentContext.getTraceHeaderFromEnvironment();
        return new FacadeSegment(recorder, traceHeader.getRootTraceId(), traceHeader.getParentId(), traceHeader.getSampled());
    }

    @Override
    public Subsegment beginSubsegment(AWSXRayRecorder recorder, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug("Beginning subsegment named: " + name);
        }
        if (null == this.getTraceEntity()) {
            FacadeSegment parentSegment = null;
            if (LambdaSegmentContext.isInitializing(LambdaSegmentContext.getTraceHeaderFromEnvironment())) {
                logger.warn("_X_AMZN_TRACE_ID is missing a trace ID, parent ID, or sampling decision. Subsegment " + name + " discarded.");
                parentSegment = new FacadeSegment(recorder, new TraceID(), "", TraceHeader.SampleDecision.NOT_SAMPLED);
            } else {
                parentSegment = LambdaSegmentContext.newFacadeSegment(recorder);
            }
            SubsegmentImpl subsegment = new SubsegmentImpl(recorder, name, parentSegment);
            subsegment.setParent(parentSegment);
            this.setTraceEntity(subsegment);
            return subsegment;
        }
        Subsegment parentSubsegment = (Subsegment)this.getTraceEntity();
        TraceID environmentRootTraceId = LambdaSegmentContext.getTraceHeaderFromEnvironment().getRootTraceId();
        if (null != environmentRootTraceId && !environmentRootTraceId.equals(parentSubsegment.getParentSegment().getTraceId())) {
            this.clearTraceEntity();
            return this.beginSubsegment(recorder, name);
        }
        SubsegmentImpl subsegment = new SubsegmentImpl(recorder, name, parentSubsegment.getParentSegment());
        subsegment.setParent(parentSubsegment);
        parentSubsegment.addSubsegment(subsegment);
        this.setTraceEntity(subsegment);
        return subsegment;
    }

    @Override
    public void endSubsegment(AWSXRayRecorder recorder) {
        Entity current = this.getTraceEntity();
        if (current instanceof Subsegment) {
            Entity parentEntity;
            if (logger.isDebugEnabled()) {
                logger.debug("Ending subsegment named: " + current.getName());
            }
            Subsegment currentSubsegment = (Subsegment)current;
            currentSubsegment.end();
            if (recorder.getStreamingStrategy().requiresStreaming(currentSubsegment.getParentSegment())) {
                recorder.getStreamingStrategy().streamSome(currentSubsegment.getParentSegment(), recorder.getEmitter());
            }
            if ((parentEntity = current.getParent()) instanceof FacadeSegment) {
                if (((FacadeSegment)parentEntity).isSampled()) {
                    current.getCreator().getEmitter().sendSubsegment((Subsegment)current);
                }
                this.clearTraceEntity();
            } else {
                this.setTraceEntity(current.getParent());
            }
        } else {
            throw new SubsegmentNotFoundException("Failed to end a subsegment: subsegment cannot be found.");
        }
    }
}

