/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.plugins;

import com.amazonaws.util.EC2MetadataUtils;
import com.amazonaws.xray.plugins.Plugin;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2Plugin
implements Plugin {
    private static final Log logger = LogFactory.getLog(EC2Plugin.class);
    private static final String SERVICE_NAME = "ec2";
    private HashMap<String, Object> runtimeContext = new HashMap();
    private static final String ORIGIN = "AWS::EC2::Instance";

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void populateRuntimeContext() {
        if (null != EC2MetadataUtils.getInstanceId()) {
            this.runtimeContext.put("instance_id", EC2MetadataUtils.getInstanceId());
        }
        if (null != EC2MetadataUtils.getAvailabilityZone()) {
            this.runtimeContext.put("availability_zone", EC2MetadataUtils.getAvailabilityZone());
        }
    }

    @Override
    public Map<String, Object> getRuntimeContext() {
        this.populateRuntimeContext();
        return this.runtimeContext;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }
}

