/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.rule;

import com.amazonaws.services.xray.model.SamplingRule;
import com.amazonaws.xray.entities.SearchPattern;
import com.amazonaws.xray.strategy.sampling.SamplingRequest;
import java.util.Collections;
import java.util.Map;

public class Matchers {
    private Map<String, String> attributes;
    private String service;
    private String method;
    private String host;
    private String url;
    private String serviceType;

    public Matchers(SamplingRule r) {
        this.host = r.getHost();
        this.service = r.getServiceName();
        this.method = r.getHTTPMethod();
        this.url = r.getURLPath();
        this.serviceType = r.getServiceType();
        this.attributes = r.getAttributes() == null ? Collections.emptyMap() : r.getAttributes();
    }

    boolean match(SamplingRequest req) {
        Map<String, String> requestAttributes = req.getAttributes();
        for (Map.Entry<String, String> a : this.attributes.entrySet()) {
            if (!requestAttributes.containsKey(a.getKey())) {
                return false;
            }
            if (SearchPattern.wildcardMatch(a.getValue(), requestAttributes.get(a.getKey()))) continue;
            return false;
        }
        return SearchPattern.wildcardMatch(this.url, req.getUrl().orElse("")) && SearchPattern.wildcardMatch(this.service, req.getService().orElse("")) && SearchPattern.wildcardMatch(this.method, req.getMethod().orElse("")) && SearchPattern.wildcardMatch(this.host, req.getHost().orElse("")) && SearchPattern.wildcardMatch(this.serviceType, req.getServiceType().orElse(""));
    }
}

