/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.StackResourceDriftStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeStackResourceDriftsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackName;
    private SdkInternalList<String> stackResourceDriftStatusFilters;
    private String nextToken;
    private Integer maxResults;

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackName() {
        return this.stackName;
    }

    public DescribeStackResourceDriftsRequest withStackName(String stackName) {
        this.setStackName(stackName);
        return this;
    }

    public List<String> getStackResourceDriftStatusFilters() {
        if (this.stackResourceDriftStatusFilters == null) {
            this.stackResourceDriftStatusFilters = new SdkInternalList();
        }
        return this.stackResourceDriftStatusFilters;
    }

    public void setStackResourceDriftStatusFilters(Collection<String> stackResourceDriftStatusFilters) {
        if (stackResourceDriftStatusFilters == null) {
            this.stackResourceDriftStatusFilters = null;
            return;
        }
        this.stackResourceDriftStatusFilters = new SdkInternalList<String>(stackResourceDriftStatusFilters);
    }

    public DescribeStackResourceDriftsRequest withStackResourceDriftStatusFilters(String ... stackResourceDriftStatusFilters) {
        if (this.stackResourceDriftStatusFilters == null) {
            this.setStackResourceDriftStatusFilters(new SdkInternalList<String>(stackResourceDriftStatusFilters.length));
        }
        for (String ele : stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters.add(ele);
        }
        return this;
    }

    public DescribeStackResourceDriftsRequest withStackResourceDriftStatusFilters(Collection<String> stackResourceDriftStatusFilters) {
        this.setStackResourceDriftStatusFilters(stackResourceDriftStatusFilters);
        return this;
    }

    public DescribeStackResourceDriftsRequest withStackResourceDriftStatusFilters(StackResourceDriftStatus ... stackResourceDriftStatusFilters) {
        SdkInternalList<String> stackResourceDriftStatusFiltersCopy = new SdkInternalList<String>(stackResourceDriftStatusFilters.length);
        for (StackResourceDriftStatus value : stackResourceDriftStatusFilters) {
            stackResourceDriftStatusFiltersCopy.add(value.toString());
        }
        if (this.getStackResourceDriftStatusFilters() == null) {
            this.setStackResourceDriftStatusFilters(stackResourceDriftStatusFiltersCopy);
        } else {
            this.getStackResourceDriftStatusFilters().addAll(stackResourceDriftStatusFiltersCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeStackResourceDriftsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeStackResourceDriftsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackName() != null) {
            sb.append("StackName: ").append(this.getStackName()).append(",");
        }
        if (this.getStackResourceDriftStatusFilters() != null) {
            sb.append("StackResourceDriftStatusFilters: ").append(this.getStackResourceDriftStatusFilters()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceDriftsRequest)) {
            return false;
        }
        DescribeStackResourceDriftsRequest other = (DescribeStackResourceDriftsRequest)obj;
        if (other.getStackName() == null ^ this.getStackName() == null) {
            return false;
        }
        if (other.getStackName() != null && !other.getStackName().equals(this.getStackName())) {
            return false;
        }
        if (other.getStackResourceDriftStatusFilters() == null ^ this.getStackResourceDriftStatusFilters() == null) {
            return false;
        }
        if (other.getStackResourceDriftStatusFilters() != null && !other.getStackResourceDriftStatusFilters().equals(this.getStackResourceDriftStatusFilters())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackName() == null ? 0 : this.getStackName().hashCode());
        hashCode = 31 * hashCode + (this.getStackResourceDriftStatusFilters() == null ? 0 : this.getStackResourceDriftStatusFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public DescribeStackResourceDriftsRequest clone() {
        return (DescribeStackResourceDriftsRequest)super.clone();
    }
}

