/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws.sqs;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.Message;
import java.util.function.Consumer;
import lombok.Generated;

public class QueueHandler {
    private AmazonSQS sqs;
    private String queueUrl;
    private Consumer<Message> messageHandler;

    public QueueHandler(String queueUrl, Consumer<Message> messageHandler) {
        this((AmazonSQS)AmazonSQSClientBuilder.standard().build(), queueUrl, messageHandler);
    }

    public void process() {
        for (Message message : this.sqs.receiveMessage(this.queueUrl).getMessages()) {
            this.messageHandler.accept(message);
            this.sqs.deleteMessage(this.queueUrl, message.getReceiptHandle());
        }
    }

    @Generated
    public QueueHandler(AmazonSQS sqs, String queueUrl, Consumer<Message> messageHandler) {
        this.sqs = sqs;
        this.queueUrl = queueUrl;
        this.messageHandler = messageHandler;
    }
}

