/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.client.impl;

import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.http.apache.SdkProxyRoutePlanner;
import com.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazonaws.http.apache.client.impl.SdkHttpClient;
import com.amazonaws.http.apache.utils.ApacheUtils;
import com.amazonaws.http.client.ConnectionManagerFactory;
import com.amazonaws.http.client.HttpClientFactory;
import com.amazonaws.http.conn.ClientConnectionManagerFactory;
import com.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import com.amazonaws.http.protocol.SdkHttpRequestExecutor;
import com.amazonaws.http.settings.HttpClientSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings2) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings2);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings2)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings2.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings2.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings2);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings2.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings2.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings2) {
        if (settings2.isProxyEnabled()) {
            LOG.info("Configuring Proxy. Proxy Host: " + settings2.getProxyHost() + " Proxy Port: " + settings2.getProxyPort());
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings2.getProxyHost(), settings2.getProxyPort(), settings2.getProxyProtocol(), settings2.getNonProxyHosts()));
            if (settings2.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings2));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings2) {
        return settings2.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings2.getMaxIdleConnectionTime()) : null;
    }
}

