/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.StackResourceSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListStackResourcesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<StackResourceSummary> stackResourceSummaries;
    private String nextToken;

    public List<StackResourceSummary> getStackResourceSummaries() {
        if (this.stackResourceSummaries == null) {
            this.stackResourceSummaries = new SdkInternalList();
        }
        return this.stackResourceSummaries;
    }

    public void setStackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
        if (stackResourceSummaries == null) {
            this.stackResourceSummaries = null;
            return;
        }
        this.stackResourceSummaries = new SdkInternalList<StackResourceSummary>(stackResourceSummaries);
    }

    public ListStackResourcesResult withStackResourceSummaries(StackResourceSummary ... stackResourceSummaries) {
        if (this.stackResourceSummaries == null) {
            this.setStackResourceSummaries(new SdkInternalList<StackResourceSummary>(stackResourceSummaries.length));
        }
        for (StackResourceSummary ele : stackResourceSummaries) {
            this.stackResourceSummaries.add(ele);
        }
        return this;
    }

    public ListStackResourcesResult withStackResourceSummaries(Collection<StackResourceSummary> stackResourceSummaries) {
        this.setStackResourceSummaries(stackResourceSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListStackResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackResourceSummaries() != null) {
            sb.append("StackResourceSummaries: ").append(this.getStackResourceSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackResourcesResult)) {
            return false;
        }
        ListStackResourcesResult other = (ListStackResourcesResult)obj;
        if (other.getStackResourceSummaries() == null ^ this.getStackResourceSummaries() == null) {
            return false;
        }
        if (other.getStackResourceSummaries() != null && !other.getStackResourceSummaries().equals(this.getStackResourceSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getStackResourceSummaries() == null ? 0 : this.getStackResourceSummaries().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode2;
    }

    public ListStackResourcesResult clone() {
        try {
            return (ListStackResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

