/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.LoggingConfig;
import com.amazonaws.services.cloudformation.model.RegisterTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RegisterTypeRequestMarshaller
implements Marshaller<Request<RegisterTypeRequest>, RegisterTypeRequest> {
    @Override
    public Request<RegisterTypeRequest> marshall(RegisterTypeRequest registerTypeRequest) {
        LoggingConfig loggingConfig;
        if (registerTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterTypeRequest> request = new DefaultRequest<RegisterTypeRequest>(registerTypeRequest, "AmazonCloudFormation");
        request.addParameter("Action", "RegisterType");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerTypeRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(registerTypeRequest.getType()));
        }
        if (registerTypeRequest.getTypeName() != null) {
            request.addParameter("TypeName", StringUtils.fromString(registerTypeRequest.getTypeName()));
        }
        if (registerTypeRequest.getSchemaHandlerPackage() != null) {
            request.addParameter("SchemaHandlerPackage", StringUtils.fromString(registerTypeRequest.getSchemaHandlerPackage()));
        }
        if ((loggingConfig = registerTypeRequest.getLoggingConfig()) != null) {
            if (loggingConfig.getLogRoleArn() != null) {
                request.addParameter("LoggingConfig.LogRoleArn", StringUtils.fromString(loggingConfig.getLogRoleArn()));
            }
            if (loggingConfig.getLogGroupName() != null) {
                request.addParameter("LoggingConfig.LogGroupName", StringUtils.fromString(loggingConfig.getLogGroupName()));
            }
        }
        if (registerTypeRequest.getExecutionRoleArn() != null) {
            request.addParameter("ExecutionRoleArn", StringUtils.fromString(registerTypeRequest.getExecutionRoleArn()));
        }
        if (registerTypeRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString(registerTypeRequest.getClientRequestToken()));
        }
        return request;
    }
}

