/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.services.cloudformation.model.ResourceToImport;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class ResourceToImportStaxUnmarshaller
implements Unmarshaller<ResourceToImport, StaxUnmarshallerContext> {
    private static ResourceToImportStaxUnmarshaller instance;

    @Override
    public ResourceToImport unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceToImport resourceToImport = new ResourceToImport();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceToImport;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    resourceToImport.setResourceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    resourceToImport.setLogicalResourceId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ResourceIdentifier/entry", targetDepth)) continue;
                Map.Entry<String, String> entry = ResourceIdentifierMapEntryUnmarshaller.getInstance().unmarshall(context);
                resourceToImport.addResourceIdentifierEntry(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceToImport;
    }

    public static ResourceToImportStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceToImportStaxUnmarshaller();
        }
        return instance;
    }

    private static class ResourceIdentifierMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static ResourceIdentifierMapEntryUnmarshaller instance;

        private ResourceIdentifierMapEntryUnmarshaller() {
        }

        @Override
        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry<String, String> entry = new MapEntry<String, String>();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static ResourceIdentifierMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new ResourceIdentifierMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

