/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.events.models.dynamodb;

import com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue;
import com.amazonaws.services.lambda.runtime.events.models.dynamodb.StreamViewType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class StreamRecord
implements Serializable,
Cloneable {
    private Date approximateCreationDateTime;
    private Map<String, AttributeValue> keys;
    private Map<String, AttributeValue> newImage;
    private Map<String, AttributeValue> oldImage;
    private String sequenceNumber;
    private Long sizeBytes;
    private String streamViewType;

    public void setApproximateCreationDateTime(Date approximateCreationDateTime) {
        this.approximateCreationDateTime = approximateCreationDateTime;
    }

    public Date getApproximateCreationDateTime() {
        return this.approximateCreationDateTime;
    }

    public StreamRecord withApproximateCreationDateTime(Date approximateCreationDateTime) {
        this.setApproximateCreationDateTime(approximateCreationDateTime);
        return this;
    }

    public Map<String, AttributeValue> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, AttributeValue> keys2) {
        this.keys = keys2;
    }

    public StreamRecord withKeys(Map<String, AttributeValue> keys2) {
        this.setKeys(keys2);
        return this;
    }

    public StreamRecord addKeysEntry(String key, AttributeValue value) {
        if (null == this.keys) {
            this.keys = new HashMap<String, AttributeValue>();
        }
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.keys.put(key, value);
        return this;
    }

    public StreamRecord clearKeysEntries() {
        this.keys = null;
        return this;
    }

    public Map<String, AttributeValue> getNewImage() {
        return this.newImage;
    }

    public void setNewImage(Map<String, AttributeValue> newImage) {
        this.newImage = newImage;
    }

    public StreamRecord withNewImage(Map<String, AttributeValue> newImage) {
        this.setNewImage(newImage);
        return this;
    }

    public StreamRecord addNewImageEntry(String key, AttributeValue value) {
        if (null == this.newImage) {
            this.newImage = new HashMap<String, AttributeValue>();
        }
        if (this.newImage.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.newImage.put(key, value);
        return this;
    }

    public StreamRecord clearNewImageEntries() {
        this.newImage = null;
        return this;
    }

    public Map<String, AttributeValue> getOldImage() {
        return this.oldImage;
    }

    public void setOldImage(Map<String, AttributeValue> oldImage) {
        this.oldImage = oldImage;
    }

    public StreamRecord withOldImage(Map<String, AttributeValue> oldImage) {
        this.setOldImage(oldImage);
        return this;
    }

    public StreamRecord addOldImageEntry(String key, AttributeValue value) {
        if (null == this.oldImage) {
            this.oldImage = new HashMap<String, AttributeValue>();
        }
        if (this.oldImage.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.oldImage.put(key, value);
        return this;
    }

    public StreamRecord clearOldImageEntries() {
        this.oldImage = null;
        return this;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public StreamRecord withSequenceNumber(String sequenceNumber) {
        this.setSequenceNumber(sequenceNumber);
        return this;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public StreamRecord withSizeBytes(Long sizeBytes) {
        this.setSizeBytes(sizeBytes);
        return this;
    }

    public String getStreamViewType() {
        return this.streamViewType;
    }

    public void setStreamViewType(StreamViewType streamViewType) {
        this.withStreamViewType(streamViewType);
    }

    public StreamRecord withStreamViewType(StreamViewType streamViewType) {
        this.streamViewType = streamViewType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApproximateCreationDateTime() != null) {
            sb.append("ApproximateCreationDateTime: ").append(this.getApproximateCreationDateTime()).append(",");
        }
        if (this.getKeys() != null) {
            sb.append("Keys: ").append(this.getKeys()).append(",");
        }
        if (this.getNewImage() != null) {
            sb.append("NewImage: ").append(this.getNewImage()).append(",");
        }
        if (this.getOldImage() != null) {
            sb.append("OldImage: ").append(this.getOldImage()).append(",");
        }
        if (this.getSequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.getSequenceNumber()).append(",");
        }
        if (this.getSizeBytes() != null) {
            sb.append("SizeBytes: ").append(this.getSizeBytes()).append(",");
        }
        if (this.getStreamViewType() != null) {
            sb.append("StreamViewType: ").append(this.getStreamViewType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord)obj;
        if (other.getApproximateCreationDateTime() == null ^ this.getApproximateCreationDateTime() == null) {
            return false;
        }
        if (other.getApproximateCreationDateTime() != null && !other.getApproximateCreationDateTime().equals(this.getApproximateCreationDateTime())) {
            return false;
        }
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (other.getKeys() != null && !other.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (other.getNewImage() == null ^ this.getNewImage() == null) {
            return false;
        }
        if (other.getNewImage() != null && !other.getNewImage().equals(this.getNewImage())) {
            return false;
        }
        if (other.getOldImage() == null ^ this.getOldImage() == null) {
            return false;
        }
        if (other.getOldImage() != null && !other.getOldImage().equals(this.getOldImage())) {
            return false;
        }
        if (other.getSequenceNumber() == null ^ this.getSequenceNumber() == null) {
            return false;
        }
        if (other.getSequenceNumber() != null && !other.getSequenceNumber().equals(this.getSequenceNumber())) {
            return false;
        }
        if (other.getSizeBytes() == null ^ this.getSizeBytes() == null) {
            return false;
        }
        if (other.getSizeBytes() != null && !other.getSizeBytes().equals(this.getSizeBytes())) {
            return false;
        }
        if (other.getStreamViewType() == null ^ this.getStreamViewType() == null) {
            return false;
        }
        return other.getStreamViewType() == null || other.getStreamViewType().equals(this.getStreamViewType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getApproximateCreationDateTime() == null ? 0 : this.getApproximateCreationDateTime().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getNewImage() == null ? 0 : this.getNewImage().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getOldImage() == null ? 0 : this.getOldImage().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getSequenceNumber() == null ? 0 : this.getSequenceNumber().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getSizeBytes() == null ? 0 : this.getSizeBytes().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getStreamViewType() == null ? 0 : this.getStreamViewType().hashCode());
        return hashCode2;
    }

    public StreamRecord clone() {
        try {
            return (StreamRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

