/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.xray.model.TelemetryRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutTelemetryRecordsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<TelemetryRecord> telemetryRecords;
    private String eC2InstanceId;
    private String hostname;
    private String resourceARN;

    public List<TelemetryRecord> getTelemetryRecords() {
        return this.telemetryRecords;
    }

    public void setTelemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
        if (telemetryRecords == null) {
            this.telemetryRecords = null;
            return;
        }
        this.telemetryRecords = new ArrayList<TelemetryRecord>(telemetryRecords);
    }

    public PutTelemetryRecordsRequest withTelemetryRecords(TelemetryRecord ... telemetryRecords) {
        if (this.telemetryRecords == null) {
            this.setTelemetryRecords(new ArrayList<TelemetryRecord>(telemetryRecords.length));
        }
        for (TelemetryRecord ele : telemetryRecords) {
            this.telemetryRecords.add(ele);
        }
        return this;
    }

    public PutTelemetryRecordsRequest withTelemetryRecords(Collection<TelemetryRecord> telemetryRecords) {
        this.setTelemetryRecords(telemetryRecords);
        return this;
    }

    public void setEC2InstanceId(String eC2InstanceId) {
        this.eC2InstanceId = eC2InstanceId;
    }

    public String getEC2InstanceId() {
        return this.eC2InstanceId;
    }

    public PutTelemetryRecordsRequest withEC2InstanceId(String eC2InstanceId) {
        this.setEC2InstanceId(eC2InstanceId);
        return this;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public PutTelemetryRecordsRequest withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public PutTelemetryRecordsRequest withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTelemetryRecords() != null) {
            sb.append("TelemetryRecords: ").append(this.getTelemetryRecords()).append(",");
        }
        if (this.getEC2InstanceId() != null) {
            sb.append("EC2InstanceId: ").append(this.getEC2InstanceId()).append(",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: ").append(this.getHostname()).append(",");
        }
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTelemetryRecordsRequest)) {
            return false;
        }
        PutTelemetryRecordsRequest other = (PutTelemetryRecordsRequest)obj;
        if (other.getTelemetryRecords() == null ^ this.getTelemetryRecords() == null) {
            return false;
        }
        if (other.getTelemetryRecords() != null && !other.getTelemetryRecords().equals(this.getTelemetryRecords())) {
            return false;
        }
        if (other.getEC2InstanceId() == null ^ this.getEC2InstanceId() == null) {
            return false;
        }
        if (other.getEC2InstanceId() != null && !other.getEC2InstanceId().equals(this.getEC2InstanceId())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        return other.getResourceARN() == null || other.getResourceARN().equals(this.getResourceARN());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getTelemetryRecords() == null ? 0 : this.getTelemetryRecords().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getEC2InstanceId() == null ? 0 : this.getEC2InstanceId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        return hashCode2;
    }

    @Override
    public PutTelemetryRecordsRequest clone() {
        return (PutTelemetryRecordsRequest)super.clone();
    }
}

