/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.Segment;
import com.amazonaws.services.xray.model.transform.TraceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Trace
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private Double duration;
    private List<Segment> segments;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Trace withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public Double getDuration() {
        return this.duration;
    }

    public Trace withDuration(Double duration) {
        this.setDuration(duration);
        return this;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(Collection<Segment> segments) {
        if (segments == null) {
            this.segments = null;
            return;
        }
        this.segments = new ArrayList<Segment>(segments);
    }

    public Trace withSegments(Segment ... segments) {
        if (this.segments == null) {
            this.setSegments(new ArrayList<Segment>(segments.length));
        }
        for (Segment ele : segments) {
            this.segments.add(ele);
        }
        return this;
    }

    public Trace withSegments(Collection<Segment> segments) {
        this.setSegments(segments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getSegments() != null) {
            sb.append("Segments: ").append(this.getSegments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        Trace other = (Trace)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getSegments() == null ^ this.getSegments() == null) {
            return false;
        }
        return other.getSegments() == null || other.getSegments().equals(this.getSegments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getSegments() == null ? 0 : this.getSegments().hashCode());
        return hashCode2;
    }

    public Trace clone() {
        try {
            return (Trace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

