/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.contexts.SegmentContextResolverChain;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.AWSLogReference;
import com.amazonaws.xray.listeners.SegmentListener;
import com.amazonaws.xray.plugins.EC2Plugin;
import com.amazonaws.xray.plugins.ECSPlugin;
import com.amazonaws.xray.plugins.EKSPlugin;
import com.amazonaws.xray.plugins.ElasticBeanstalkPlugin;
import com.amazonaws.xray.plugins.Plugin;
import com.amazonaws.xray.strategy.ContextMissingStrategy;
import com.amazonaws.xray.strategy.IgnoreErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.LogErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.PrioritizationStrategy;
import com.amazonaws.xray.strategy.RuntimeErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.StreamingStrategy;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayRecorderBuilder {
    private static final Log logger = LogFactory.getLog(AWSXRayRecorderBuilder.class);
    private final Collection<Plugin> plugins = new HashSet<Plugin>();
    private SamplingStrategy samplingStrategy;
    private StreamingStrategy streamingStrategy;
    private PrioritizationStrategy prioritizationStrategy;
    private ThrowableSerializationStrategy throwableSerializationStrategy;
    private ContextMissingStrategy contextMissingStrategy;
    private SegmentContextResolverChain segmentContextResolverChain;
    private Emitter emitter;
    private final Collection<SegmentListener> segmentListeners = new ArrayList<SegmentListener>();
    private static final Map<String, Integer> originPriority = new HashMap<String, Integer>();

    private AWSXRayRecorderBuilder() {
    }

    public static Optional<ContextMissingStrategy> contextMissingStrategyFromEnvironmentVariable() {
        String contextMissingStrategyOverrideValue = System.getenv("AWS_XRAY_CONTEXT_MISSING");
        return AWSXRayRecorderBuilder.getContextMissingStrategy(contextMissingStrategyOverrideValue);
    }

    public static Optional<ContextMissingStrategy> contextMissingStrategyFromSystemProperty() {
        String contextMissingStrategyOverrideValue = System.getProperty("com.amazonaws.xray.strategy.contextMissingStrategy");
        return AWSXRayRecorderBuilder.getContextMissingStrategy(contextMissingStrategyOverrideValue);
    }

    private static Optional<ContextMissingStrategy> getContextMissingStrategy(String contextMissingStrategyOverrideValue) {
        if (null != contextMissingStrategyOverrideValue) {
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("LOG_ERROR")) {
                return Optional.of(new LogErrorContextMissingStrategy());
            }
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("RUNTIME_ERROR")) {
                return Optional.of(new RuntimeErrorContextMissingStrategy());
            }
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("IGNORE_ERROR")) {
                return Optional.of(new IgnoreErrorContextMissingStrategy());
            }
        }
        return Optional.empty();
    }

    public static AWSXRayRecorderBuilder standard() {
        return new AWSXRayRecorderBuilder();
    }

    public static AWSXRayRecorder defaultRecorder() {
        return AWSXRayRecorderBuilder.standard().build();
    }

    public AWSXRayRecorderBuilder withPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public AWSXRayRecorderBuilder withSamplingStrategy(SamplingStrategy samplingStrategy) {
        this.samplingStrategy = samplingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withPrioritizationStrategy(PrioritizationStrategy prioritizationStrategy) {
        this.prioritizationStrategy = prioritizationStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withThrowableSerializationStrategy(ThrowableSerializationStrategy throwableSerializationStrategy) {
        this.throwableSerializationStrategy = throwableSerializationStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withEmitter(Emitter emitter) {
        this.emitter = emitter;
        return this;
    }

    public AWSXRayRecorderBuilder withSegmentContextResolverChain(SegmentContextResolverChain segmentContextResolverChain) {
        this.segmentContextResolverChain = segmentContextResolverChain;
        return this;
    }

    public AWSXRayRecorderBuilder withSegmentListener(SegmentListener segmentListener) {
        this.segmentListeners.add(segmentListener);
        return this;
    }

    public AWSXRayRecorderBuilder withContextMissingStrategy(ContextMissingStrategy contextMissingStrategy) {
        this.contextMissingStrategy = contextMissingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withDefaultPlugins() {
        this.plugins.add(new EC2Plugin());
        this.plugins.add(new ECSPlugin());
        this.plugins.add(new EKSPlugin());
        this.plugins.add(new ElasticBeanstalkPlugin());
        return this;
    }

    public AWSXRayRecorder build() {
        AWSXRayRecorder client = new AWSXRayRecorder();
        if (null != this.samplingStrategy) {
            client.setSamplingStrategy(this.samplingStrategy);
        }
        if (null != this.streamingStrategy) {
            client.setStreamingStrategy(this.streamingStrategy);
        }
        if (null != this.prioritizationStrategy) {
            client.setPrioritizationStrategy(this.prioritizationStrategy);
        }
        if (null != this.throwableSerializationStrategy) {
            client.setThrowableSerializationStrategy(this.throwableSerializationStrategy);
        }
        if (null != this.contextMissingStrategy && !AWSXRayRecorderBuilder.contextMissingStrategyFromEnvironmentVariable().isPresent() && !AWSXRayRecorderBuilder.contextMissingStrategyFromSystemProperty().isPresent()) {
            client.setContextMissingStrategy(this.contextMissingStrategy);
        }
        if (null != this.segmentContextResolverChain) {
            client.setSegmentContextResolverChain(this.segmentContextResolverChain);
        }
        if (null != this.emitter) {
            client.setEmitter(this.emitter);
        }
        if (!this.segmentListeners.isEmpty()) {
            client.addAllSegmentListeners(this.segmentListeners);
        }
        this.plugins.stream().filter(Objects::nonNull).filter(p -> p.isEnabled()).forEach(plugin -> {
            logger.info("Collecting trace metadata from " + plugin.getClass().getName() + ".");
            try {
                Map<String, Object> runtimeContext = plugin.getRuntimeContext();
                if (!runtimeContext.isEmpty()) {
                    client.putRuntimeContext(plugin.getServiceName(), runtimeContext);
                    if (client.getOrigin() == null || originPriority.get(plugin.getOrigin()) < originPriority.get(client.getOrigin())) {
                        client.setOrigin(plugin.getOrigin());
                    }
                } else {
                    logger.warn(plugin.getClass().getName() + " plugin returned empty runtime context data. The recorder will not be setting segment origin or runtime context values from this plugin.");
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get runtime context from " + plugin.getClass().getName() + ".", e);
            }
            try {
                Set<AWSLogReference> logReferences = plugin.getLogReferences();
                if (Objects.nonNull(logReferences)) {
                    if (!logReferences.isEmpty()) {
                        client.addAllLogReferences(logReferences);
                    } else {
                        logger.warn(plugin.getClass().getName() + " plugin returned empty Log References. The recorder will not reflect the logs from this plugin.");
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get log references from " + plugin.getClass().getName() + ".", e);
            }
        });
        return client;
    }

    static {
        originPriority.put("AWS::ElasticBeanstalk::Environment", 0);
        originPriority.put("AWS::EKS::Container", 1);
        originPriority.put("AWS::ECS::Container", 2);
        originPriority.put("AWS::EC2::Instance", 3);
    }
}

