/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.entities.ThrowableDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cause {
    private static final Log logger = LogFactory.getLog(Cause.class);
    private String workingDirectory;
    private String id;
    private String message;
    private Collection<String> paths = new ArrayList<String>();
    private List<ThrowableDescription> exceptions = new ArrayList<ThrowableDescription>();

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Collection<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Collection<String> paths) {
        this.paths = paths;
    }

    public List<ThrowableDescription> getExceptions() {
        return this.exceptions;
    }

    public void addException(ThrowableDescription descriptor2) {
        if (this.exceptions.isEmpty()) {
            this.addWorkingDirectoryAndPaths();
        }
        this.exceptions.add(descriptor2);
    }

    public void addExceptions(List<ThrowableDescription> descriptors) {
        if (this.exceptions.isEmpty()) {
            this.addWorkingDirectoryAndPaths();
        }
        this.exceptions.addAll(descriptors);
    }

    private void addWorkingDirectoryAndPaths() {
        try {
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (SecurityException se) {
            logger.warn("Unable to set working directory.", se);
        }
    }
}

