/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.ThreadLocalStorage;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Objects;

public class TraceID {
    private static final char VERSION = '1';
    private static final char DELIMITER = '-';
    private static final String HEX_PREFIX = "0x";
    private BigInteger number = new BigInteger(96, ThreadLocalStorage.getRandom());
    private long startTime;
    private static final int PRIME = 31;

    public static TraceID fromString(String string) {
        TraceID traceId = new TraceID();
        String[] parts = string.trim().split("-");
        if (parts.length >= 3) {
            traceId.setStartTime(Long.decode(HEX_PREFIX + parts[1]));
            traceId.setNumber(new BigInteger(parts[2], 16));
        }
        return traceId;
    }

    public TraceID() {
        this(Instant.now().getEpochSecond());
    }

    public TraceID(long startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        String paddedNumber = this.number.toString(16);
        while (paddedNumber.length() < 24) {
            paddedNumber = '0' + paddedNumber;
        }
        return "1-" + Long.toHexString(this.startTime) + '-' + paddedNumber;
    }

    public BigInteger getNumber() {
        return this.number;
    }

    public void setNumber(BigInteger number) {
        this.number = number;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + (this.number == null ? 0 : this.number.hashCode());
        result2 = 31 * result2 + (int)(this.startTime ^ this.startTime >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TraceID)) {
            return false;
        }
        TraceID other = (TraceID)obj;
        return Objects.equals(this.number, other.number) && this.startTime == other.startTime;
    }
}

