/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.handlers;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.handlers.config.AWSOperationHandler;
import com.amazonaws.xray.handlers.config.AWSOperationHandlerManifest;
import com.amazonaws.xray.handlers.config.AWSServiceHandlerManifest;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingHandler
extends RequestHandler2 {
    private static final Log logger = LogFactory.getLog(TracingHandler.class);
    private AWSServiceHandlerManifest awsServiceHandlerManifest;
    private ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private static final URL DEFAULT_OPERATION_PARAMETER_WHITELIST = TracingHandler.class.getResource("/com/amazonaws/xray/handlers/DefaultOperationParameterWhitelist.json");
    private static final String GETTER_METHOD_NAME_PREFIX = "get";
    private static final String S3_SERVICE_NAME = "Amazon S3";
    private static final String S3_PRESIGN_REQUEST = "GeneratePresignedUrl";
    private static final String S3_REQUEST_ID_HEADER_KEY = "x-amz-request-id";
    private static final String XRAY_SERVICE_NAME = "AWSXRay";
    private static final String XRAY_SAMPLING_RULE_REQUEST = "GetSamplingRules";
    private static final String XRAY_SAMPLING_TARGET_REQUEST = "GetSamplingTargets";
    private static final String REQUEST_ID_SUBSEGMENT_KEY = "request_id";
    private final String accountId;
    private AWSXRayRecorder recorder;
    private HandlerContextKey<Entity> entityKey = new HandlerContextKey("AWS X-Ray Entity");
    private HandlerContextKey<Long> executingThreadKey = new HandlerContextKey("AWS X-Ray Executing Thread ID");
    private static final String REGEX = "([a-z])([A-Z]+)";
    private static final String REPLACE = "$1_$2";

    private void initRequestManifest(URL operationParameterWhitelist) {
        if (null != operationParameterWhitelist) {
            try {
                this.awsServiceHandlerManifest = this.mapper.readValue(operationParameterWhitelist, AWSServiceHandlerManifest.class);
                return;
            }
            catch (IOException e) {
                logger.error("Unable to parse operation parameter whitelist at " + operationParameterWhitelist.getPath() + ". Falling back to default operation parameter whitelist at " + DEFAULT_OPERATION_PARAMETER_WHITELIST.getPath() + ".", e);
            }
        }
        try {
            this.awsServiceHandlerManifest = this.mapper.readValue(DEFAULT_OPERATION_PARAMETER_WHITELIST, AWSServiceHandlerManifest.class);
        }
        catch (IOException e) {
            logger.error("Unable to parse default operation parameter whitelist at " + DEFAULT_OPERATION_PARAMETER_WHITELIST.getPath() + ". This will affect this handler's ability to capture AWS operation parameter information.", e);
        }
    }

    public TracingHandler() {
        this(AWSXRay.getGlobalRecorder(), null, null);
    }

    public TracingHandler(AWSXRayRecorder recorder) {
        this(recorder, null, null);
    }

    public TracingHandler(String accountId) {
        this(AWSXRay.getGlobalRecorder(), accountId, null);
    }

    public TracingHandler(AWSXRayRecorder recorder, String accountId) {
        this(recorder, accountId, null);
    }

    public TracingHandler(URL operationParameterWhitelist) {
        this(AWSXRay.getGlobalRecorder(), null, operationParameterWhitelist);
    }

    public TracingHandler(AWSXRayRecorder recorder, URL operationParameterWhitelist) {
        this(recorder, null, operationParameterWhitelist);
    }

    public TracingHandler(String accountId, URL operationParameterWhitelist) {
        this(AWSXRay.getGlobalRecorder(), accountId, operationParameterWhitelist);
    }

    public TracingHandler(AWSXRayRecorder recorder, String accountId, URL operationParameterWhitelist) {
        this.recorder = recorder;
        this.accountId = accountId;
        this.initRequestManifest(operationParameterWhitelist);
    }

    private boolean isSubsegmentDuplicate(Optional<Subsegment> subsegment, Request<?> request) {
        return subsegment.isPresent() && Namespace.AWS.toString().equals(subsegment.get().getNamespace()) && null != this.extractServiceName(request) && this.extractServiceName(request).equals(subsegment.get().getName());
    }

    @Override
    public AmazonWebServiceRequest beforeExecution(AmazonWebServiceRequest request) {
        this.lazyLoadRecorder();
        request.addHandlerContext(this.entityKey, this.recorder.getTraceEntity());
        request.addHandlerContext(this.executingThreadKey, Thread.currentThread().getId());
        return request;
    }

    @Override
    public void beforeRequest(Request<?> request) {
        Subsegment currentSubsegment;
        String serviceName = this.extractServiceName(request);
        String operationName = this.extractOperationName(request);
        if (S3_SERVICE_NAME.equals(serviceName) && S3_PRESIGN_REQUEST.equals(operationName)) {
            return;
        }
        if (XRAY_SERVICE_NAME.equals(serviceName) && (XRAY_SAMPLING_RULE_REQUEST.equals(operationName) || XRAY_SAMPLING_TARGET_REQUEST.equals(operationName))) {
            return;
        }
        if (this.isSubsegmentDuplicate(this.recorder.getCurrentSubsegmentOptional(), request)) {
            return;
        }
        Entity entityContext = request.getHandlerContext(this.entityKey);
        if (null != entityContext) {
            this.recorder.setTraceEntity(entityContext);
        }
        if (null == (currentSubsegment = this.recorder.beginSubsegment(serviceName))) {
            return;
        }
        currentSubsegment.putAllAws(this.extractRequestParameters(request));
        currentSubsegment.putAws("operation", operationName);
        if (null != this.accountId) {
            currentSubsegment.putAws("account_id", this.accountId);
        }
        currentSubsegment.setNamespace(Namespace.AWS.toString());
        if (null != this.recorder.getCurrentSegment()) {
            TraceHeader header = new TraceHeader(this.recorder.getCurrentSegment().getTraceId(), this.recorder.getCurrentSegment().isSampled() ? currentSubsegment.getId() : null, this.recorder.getCurrentSegment().isSampled() ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED);
            request.addHeader("X-Amzn-Trace-Id", header.toString());
        }
    }

    private String extractServiceName(Request<?> request) {
        return request.getServiceName();
    }

    private String extractOperationName(Request<?> request) {
        String ret = request.getOriginalRequest().getClass().getSimpleName();
        ret = ret.substring(0, ret.length() - 7);
        return ret;
    }

    private static String toSnakeCase(String camelCase) {
        return camelCase.replaceAll(REGEX, REPLACE).toLowerCase();
    }

    private HashMap<String, Object> extractRequestParameters(Request<?> request) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (null == this.awsServiceHandlerManifest) {
            return ret;
        }
        AWSOperationHandlerManifest serviceHandler = this.awsServiceHandlerManifest.getOperationHandlerManifest(this.extractServiceName(request));
        if (null == serviceHandler) {
            return ret;
        }
        AWSOperationHandler operationHandler = serviceHandler.getOperationHandler(this.extractOperationName(request));
        if (null == operationHandler) {
            return ret;
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (null != operationHandler.getRequestParameters()) {
            operationHandler.getRequestParameters().forEach(parameterName -> {
                try {
                    Object parameterValue = originalRequest.getClass().getMethod(GETTER_METHOD_NAME_PREFIX + parameterName, new Class[0]).invoke(originalRequest, new Object[0]);
                    if (null != parameterValue) {
                        ret.put(TracingHandler.toSnakeCase(parameterName), parameterValue);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Error getting request parameter: " + parameterName, e);
                }
            });
        }
        if (null != operationHandler.getRequestDescriptors()) {
            operationHandler.getRequestDescriptors().forEach((requestKeyName, requestDescriptor) -> {
                try {
                    List parameterValue;
                    if (requestDescriptor.isMap() && requestDescriptor.shouldGetKeys()) {
                        Map parameterValue2 = (Map)originalRequest.getClass().getMethod(GETTER_METHOD_NAME_PREFIX + requestKeyName, new Class[0]).invoke(originalRequest, new Object[0]);
                        if (null != parameterValue2) {
                            String renameTo = null != requestDescriptor.getRenameTo() ? requestDescriptor.getRenameTo() : requestKeyName;
                            ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue2.keySet());
                        }
                    } else if (requestDescriptor.isList() && requestDescriptor.shouldGetCount() && null != (parameterValue = (List)originalRequest.getClass().getMethod(GETTER_METHOD_NAME_PREFIX + requestKeyName, new Class[0]).invoke(originalRequest, new Object[0]))) {
                        String renameTo = null != requestDescriptor.getRenameTo() ? requestDescriptor.getRenameTo() : requestKeyName;
                        ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue.size());
                    }
                }
                catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Error getting request parameter: " + requestKeyName, e);
                }
            });
        }
        return ret;
    }

    private HashMap<String, Object> extractResponseParameters(Request<?> request, Object response) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (null == this.awsServiceHandlerManifest) {
            return ret;
        }
        AWSOperationHandlerManifest serviceHandler = this.awsServiceHandlerManifest.getOperationHandlerManifest(this.extractServiceName(request));
        if (null == serviceHandler) {
            return ret;
        }
        AWSOperationHandler operationHandler = serviceHandler.getOperationHandler(this.extractOperationName(request));
        if (null == operationHandler) {
            return ret;
        }
        if (null != operationHandler.getResponseParameters()) {
            operationHandler.getResponseParameters().forEach(parameterName -> {
                try {
                    Object parameterValue = response.getClass().getMethod(GETTER_METHOD_NAME_PREFIX + parameterName, new Class[0]).invoke(response, new Object[0]);
                    if (null != parameterValue) {
                        ret.put(TracingHandler.toSnakeCase(parameterName), parameterValue);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Error getting response parameter: " + parameterName, e);
                }
            });
        }
        if (null != operationHandler.getResponseDescriptors()) {
            operationHandler.getResponseDescriptors().forEach((responseKeyName, responseDescriptor) -> {
                try {
                    List parameterValue;
                    if (responseDescriptor.isMap() && responseDescriptor.shouldGetKeys()) {
                        Map parameterValue2 = (Map)response.getClass().getMethod(GETTER_METHOD_NAME_PREFIX + responseKeyName, new Class[0]).invoke(response, new Object[0]);
                        if (null != parameterValue2) {
                            String renameTo = null != responseDescriptor.getRenameTo() ? responseDescriptor.getRenameTo() : responseKeyName;
                            ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue2.keySet());
                        }
                    } else if (responseDescriptor.isList() && responseDescriptor.shouldGetCount() && null != (parameterValue = (List)response.getClass().getMethod(GETTER_METHOD_NAME_PREFIX + responseKeyName, new Class[0]).invoke(response, new Object[0]))) {
                        String renameTo = null != responseDescriptor.getRenameTo() ? responseDescriptor.getRenameTo() : responseKeyName;
                        ret.put(TracingHandler.toSnakeCase(renameTo), parameterValue.size());
                    }
                }
                catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Error getting request parameter: " + responseKeyName, e);
                }
            });
        }
        return ret;
    }

    private HashMap<String, Object> extractHttpResponseInformation(AmazonServiceException ase) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, Number> response = new HashMap<String, Number>();
        response.put("status", ase.getStatusCode());
        try {
            if (null != ase.getHttpHeaders() && null != ase.getHttpHeaders().get("Content-Length")) {
                response.put("content_length", Long.parseLong(ase.getHttpHeaders().get("Content-Length")));
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn("Unable to parse Content-Length header.", nfe);
        }
        ret.put("response", response);
        return ret;
    }

    private HashMap<String, Object> extractHttpResponseInformation(HttpResponse httpResponse) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashMap<String, Number> response = new HashMap<String, Number>();
        response.put("status", httpResponse.getStatusCode());
        try {
            if (null != httpResponse.getHeaders().get("Content-Length")) {
                response.put("content_length", Long.parseLong(httpResponse.getHeaders().get("Content-Length")));
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn("Unable to parse Content-Length header.", nfe);
        }
        ret.put("response", response);
        return ret;
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
        if (this.isSubsegmentDuplicate(this.recorder.getCurrentSubsegmentOptional(), request)) {
            Optional<Subsegment> currentSubsegmentOptional = this.recorder.getCurrentSubsegmentOptional();
            if (!currentSubsegmentOptional.isPresent()) {
                return;
            }
            Subsegment currentSubsegment = currentSubsegmentOptional.get();
            this.populateAndEndSubsegment(currentSubsegment, request, response, null);
        }
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception e) {
        if (this.isSubsegmentDuplicate(this.recorder.getCurrentSubsegmentOptional(), request)) {
            int statusCodePrefix;
            Optional<Subsegment> currentSubsegmentOptional = this.recorder.getCurrentSubsegmentOptional();
            if (!currentSubsegmentOptional.isPresent()) {
                return;
            }
            Subsegment currentSubsegment = currentSubsegmentOptional.get();
            int statusCode = -1;
            if (null != response) {
                statusCode = response.getHttpResponse().getStatusCode();
            } else if (e instanceof AmazonServiceException) {
                AmazonServiceException ase = (AmazonServiceException)e;
                statusCode = ase.getStatusCode();
                if ((304 == statusCode || 412 == statusCode) && S3_SERVICE_NAME.equals(ase.getServiceName())) {
                    this.populateAndEndSubsegment(currentSubsegment, request, response, ase);
                    return;
                }
                if (RetryUtils.isThrottlingException(ase)) {
                    currentSubsegment.setError(true);
                    currentSubsegment.setThrottle(true);
                }
            }
            if (-1 != statusCode && 4 == (statusCodePrefix = statusCode / 100)) {
                currentSubsegment.setError(true);
                if (429 == statusCode) {
                    currentSubsegment.setThrottle(true);
                }
            }
            currentSubsegment.addException(e);
            if (e instanceof AmazonServiceException) {
                this.populateAndEndSubsegment(currentSubsegment, request, response, (AmazonServiceException)e);
            } else {
                this.populateAndEndSubsegment(currentSubsegment, request, response);
            }
        }
    }

    private void populateAndEndSubsegment(Subsegment currentSubsegment, Request<?> request, Response<?> response) {
        if (null != response) {
            String requestId = null;
            if (response.getAwsResponse() instanceof AmazonWebServiceResult) {
                Object metadata2 = ((AmazonWebServiceResult)response.getAwsResponse()).getSdkResponseMetadata();
                if (null != metadata2 && null != (requestId = ((ResponseMetadata)metadata2).getRequestId())) {
                    currentSubsegment.putAws(REQUEST_ID_SUBSEGMENT_KEY, requestId);
                }
            } else if (null != response.getHttpResponse()) {
                if (null != response.getHttpResponse().getHeader(S3_REQUEST_ID_HEADER_KEY)) {
                    currentSubsegment.putAws(REQUEST_ID_SUBSEGMENT_KEY, response.getHttpResponse().getHeader(S3_REQUEST_ID_HEADER_KEY));
                }
                if (null != response.getHttpResponse().getHeader("x-amz-id-2")) {
                    currentSubsegment.putAws("id_2", response.getHttpResponse().getHeader("x-amz-id-2"));
                }
            }
            currentSubsegment.putAllAws(this.extractResponseParameters(request, response.getAwsResponse()));
            currentSubsegment.putAllHttp(this.extractHttpResponseInformation(response.getHttpResponse()));
        }
        this.finalizeSubsegment(request);
    }

    private void populateAndEndSubsegment(Subsegment currentSubsegment, Request<?> request, Response<?> response, AmazonServiceException ase) {
        if (null != response) {
            this.populateAndEndSubsegment(currentSubsegment, request, response);
            return;
        }
        if (null != ase) {
            if (null != ase.getRequestId()) {
                currentSubsegment.putAws(REQUEST_ID_SUBSEGMENT_KEY, ase.getRequestId());
            }
            if (null != ase.getHttpHeaders() && null != ase.getHttpHeaders().get("x-amz-id-2")) {
                currentSubsegment.putAws("id_2", ase.getHttpHeaders().get("x-amz-id-2"));
            }
            if (null != ase.getErrorMessage()) {
                currentSubsegment.getCause().setMessage(ase.getErrorMessage());
            }
            currentSubsegment.putAllHttp(this.extractHttpResponseInformation(ase));
        }
        this.finalizeSubsegment(request);
    }

    private void finalizeSubsegment(Request<?> request) {
        this.recorder.endSubsegment();
        Long executingThreadContext = request.getHandlerContext(this.executingThreadKey);
        if (executingThreadContext != null && Thread.currentThread().getId() != executingThreadContext.longValue()) {
            this.recorder.clearTraceEntity();
        }
    }

    private void lazyLoadRecorder() {
        if (this.recorder != null) {
            return;
        }
        this.recorder = AWSXRay.getGlobalRecorder();
    }
}

