/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.plugins;

import com.amazonaws.util.EC2MetadataUtils;
import com.amazonaws.xray.entities.AWSLogReference;
import com.amazonaws.xray.entities.StringValidator;
import com.amazonaws.xray.plugins.Plugin;
import com.amazonaws.xray.utils.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EC2Plugin
implements Plugin {
    private static final Log logger = LogFactory.getLog(EC2Plugin.class);
    private static FileSystem fs;
    private static final String SERVICE_NAME = "ec2";
    public static final String ORIGIN = "AWS::EC2::Instance";
    private static final String LOG_CONFIGS = "log_configs";
    private static final String LOG_GROUP_NAME = "log_group_name";
    private static final String WINDOWS_PROGRAM_DATA = "ProgramData";
    private static final String WINDOWS_PATH = "\\Amazon\\AmazonCloudWatchAgent\\log-config.json";
    private static final String LINUX_ROOT = "/";
    private static final String LINUX_PATH = "opt/aws/amazon-cloudwatch-agent/etc/log-config.json";
    private HashMap<String, Object> runtimeContext = new HashMap();
    private Set<AWSLogReference> logReferences = new HashSet<AWSLogReference>();

    public EC2Plugin() {
        this(FileSystems.getDefault());
    }

    public EC2Plugin(FileSystem fs) {
        EC2Plugin.fs = fs;
    }

    @Override
    public boolean isEnabled() {
        return EC2MetadataUtils.getInstanceId() != null;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void populateRuntimeContext() {
        if (null != EC2MetadataUtils.getInstanceId()) {
            this.runtimeContext.put("instance_id", EC2MetadataUtils.getInstanceId());
        }
        if (null != EC2MetadataUtils.getAvailabilityZone()) {
            this.runtimeContext.put("availability_zone", EC2MetadataUtils.getAvailabilityZone());
        }
    }

    @Override
    public Map<String, Object> getRuntimeContext() {
        this.populateRuntimeContext();
        return this.runtimeContext;
    }

    public void populateLogReferences() {
        String filePath = null;
        String programData = System.getenv(WINDOWS_PROGRAM_DATA);
        if (StringValidator.isNullOrBlank(programData)) {
            for (Path root : fs.getRootDirectories()) {
                if (!root.toString().equals(LINUX_ROOT)) continue;
                filePath = "/opt/aws/amazon-cloudwatch-agent/etc/log-config.json";
                break;
            }
        } else {
            filePath = programData + WINDOWS_PATH;
        }
        if (filePath == null) {
            logger.warn("X-Ray could not recognize the file system in use. Expected file system to be Linux or Windows based.");
            return;
        }
        try {
            JsonNode logConfigs = JsonUtils.getNodeFromJsonFile(filePath, LOG_CONFIGS);
            List<String> logGroups = JsonUtils.getMatchingListFromJsonArrayNode(logConfigs, LOG_GROUP_NAME);
            for (String logGroup : logGroups) {
                AWSLogReference logReference = new AWSLogReference();
                logReference.setLogGroup(logGroup);
                this.logReferences.add(logReference);
            }
        }
        catch (IOException e) {
            logger.warn("CloudWatch Agent log configuration file not found at " + filePath + ". Install the CloudWatch Agent on this instance to record log references in X-Ray.");
        }
        catch (RuntimeException e) {
            logger.warn("An unexpected exception occurred while reading CloudWatch agent log configuration file at " + filePath + ":\n", e);
        }
    }

    @Override
    public Set<AWSLogReference> getLogReferences() {
        if (this.logReferences.isEmpty()) {
            this.populateLogReferences();
        }
        return this.logReferences;
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Plugin)) {
            return false;
        }
        return this.getOrigin().equals(((Plugin)o).getOrigin());
    }

    public int hashCode() {
        return this.getOrigin().hashCode();
    }
}

