/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.plugins;

import com.amazonaws.xray.entities.AWSLogReference;
import com.amazonaws.xray.plugins.Plugin;
import com.amazonaws.xray.utils.ContainerInsightsUtil;
import com.amazonaws.xray.utils.DockerUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EKSPlugin
implements Plugin {
    private static final String CI_APPLOG_GROUP_FORMAT = "/aws/containerinsights/%s/application";
    public static final String ORIGIN = "AWS::EKS::Container";
    private static final String SERVICE_NAME = "eks";
    private static final String POD_CONTEXT_KEY = "pod";
    private static final String CLUSTER_NAME_KEY = "cluster_name";
    private static final String CONTAINER_ID_KEY = "containerId";
    private static final Log logger = LogFactory.getLog(EKSPlugin.class);
    private String clusterName;
    private Map<String, Object> runtimeContext;
    private Set<AWSLogReference> logReferences;
    private DockerUtils dockerUtils;

    public EKSPlugin() {
        this(ContainerInsightsUtil.getClusterName());
    }

    public EKSPlugin(String clusterName) {
        this.clusterName = clusterName;
        this.runtimeContext = new HashMap<String, Object>();
        this.logReferences = new HashSet<AWSLogReference>();
        this.dockerUtils = new DockerUtils();
    }

    @Override
    public boolean isEnabled() {
        return ContainerInsightsUtil.isK8s();
    }

    @Override
    public Set<AWSLogReference> getLogReferences() {
        if (this.logReferences.isEmpty()) {
            this.populateLogReferences();
        }
        return this.logReferences;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public Map<String, Object> getRuntimeContext() {
        if (this.runtimeContext.isEmpty()) {
            this.populateRuntimeContext();
        }
        return this.runtimeContext;
    }

    private void populateLogReferences() {
        if (this.clusterName == null) {
            this.clusterName = ContainerInsightsUtil.getClusterName();
        }
        AWSLogReference log = new AWSLogReference();
        log.setLogGroup(String.format(CI_APPLOG_GROUP_FORMAT, this.clusterName));
        this.logReferences.add(log);
    }

    public void populateRuntimeContext() {
        if (this.clusterName == null) {
            this.clusterName = ContainerInsightsUtil.getClusterName();
        }
        this.runtimeContext.put(CLUSTER_NAME_KEY, this.clusterName);
        try {
            this.runtimeContext.put(CONTAINER_ID_KEY, this.dockerUtils.getContainerId());
        }
        catch (IOException e) {
            logger.error("Failed to read full container ID from kubernetes instance.", e);
        }
        try {
            this.runtimeContext.put(POD_CONTEXT_KEY, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            logger.error("Could not get pod ID from hostname.", uhe);
        }
    }

    @Override
    public String getOrigin() {
        return ORIGIN;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Plugin)) {
            return false;
        }
        return this.getOrigin().equals(((Plugin)o).getOrigin());
    }

    public int hashCode() {
        return this.getOrigin().hashCode();
    }
}

