/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.pollers;

import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.services.xray.model.GetSamplingRulesRequest;
import com.amazonaws.services.xray.model.GetSamplingRulesResult;
import com.amazonaws.services.xray.model.SamplingRule;
import com.amazonaws.services.xray.model.SamplingRuleRecord;
import com.amazonaws.xray.strategy.sampling.manifest.CentralizedManifest;
import com.amazonaws.xray.strategy.sampling.rand.RandImpl;
import com.amazonaws.xray.strategy.sampling.rule.CentralizedRule;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RulePoller {
    private static Log logger = LogFactory.getLog(RulePoller.class);
    private static final long PERIOD = 300L;
    private static final long MAX_JITTER = 5L;
    private AWSXRay client;
    private Clock clock;
    private CentralizedManifest manifest;
    private ScheduledExecutorService executor;

    public RulePoller(CentralizedManifest manifest, AWSXRay client, Clock clock) {
        this.manifest = manifest;
        this.client = client;
        this.clock = clock;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        this.executor.scheduleAtFixedRate(() -> {
            block2: {
                try {
                    this.pollRule();
                }
                catch (Throwable t) {
                    logger.error("Encountered error polling GetSamplingRules: ", t);
                    if (!(t instanceof Error)) break block2;
                    throw t;
                }
            }
        }, 0L, this.getJitterInterval(), TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private void pollRule() {
        Instant now = this.clock.instant();
        logger.info("Polling sampling rules.");
        GetSamplingRulesRequest req = new GetSamplingRulesRequest();
        GetSamplingRulesResult records = this.client.getSamplingRules(req);
        List<SamplingRule> rules = records.getSamplingRuleRecords().stream().map(SamplingRuleRecord::getSamplingRule).filter(CentralizedRule::isValid).collect(Collectors.toList());
        this.manifest.putRules(rules, now);
    }

    private long getJitterInterval() {
        RandImpl random = new RandImpl();
        long interval = Math.round(random.next() * 5.0) + 300L;
        return interval;
    }
}

