/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.pollers;

import com.amazonaws.services.xray.AWSXRay;
import com.amazonaws.services.xray.model.GetSamplingTargetsRequest;
import com.amazonaws.services.xray.model.GetSamplingTargetsResult;
import com.amazonaws.services.xray.model.SamplingStatisticsDocument;
import com.amazonaws.xray.strategy.sampling.manifest.CentralizedManifest;
import com.amazonaws.xray.strategy.sampling.rand.RandImpl;
import java.time.Clock;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TargetPoller {
    private static Log logger = LogFactory.getLog(TargetPoller.class);
    private static final long PERIOD = 10L;
    private static final long MAX_JITTER = 100L;
    private AWSXRay client;
    private Clock clock;
    private CentralizedManifest manifest;
    private ScheduledExecutorService executor;

    public TargetPoller(CentralizedManifest m, AWSXRay client, Clock clock) {
        this.manifest = m;
        this.client = client;
        this.clock = clock;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        this.executor.scheduleAtFixedRate(() -> {
            block2: {
                try {
                    this.pollManifest();
                }
                catch (Throwable t) {
                    logger.error("Encountered error polling GetSamplingTargets: ", t);
                    if (!(t instanceof Error)) break block2;
                    throw t;
                }
            }
        }, 10000L, this.getJitterInterval(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private void pollManifest() {
        List<SamplingStatisticsDocument> statistics = this.manifest.snapshots(this.clock.instant());
        if (statistics.size() == 0) {
            logger.trace("No statistics to report. Not refreshing sampling targets.");
            return;
        }
        logger.debug("Polling sampling targets.");
        GetSamplingTargetsRequest req = new GetSamplingTargetsRequest().withSamplingStatisticsDocuments(statistics);
        GetSamplingTargetsResult result2 = this.client.getSamplingTargets(req);
        this.manifest.putTargets(result2.getSamplingTargetDocuments(), this.clock.instant());
    }

    private long getJitterInterval() {
        RandImpl random = new RandImpl();
        long interval = Math.round(random.next() * 100.0) + 10000L;
        return interval;
    }
}

