/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ContainerInsightsUtil {
    private static final String K8S_CRED_FOLDER = "/var/run/secrets/kubernetes.io/serviceaccount";
    private static final String K8S_CRED_TOKEN_SUFFIX = "token";
    private static final String K8S_CRED_CERT_SUFFIX = "ca.crt";
    private static final String K8S_URL = "https://kubernetes.default.svc";
    private static final String CI_CONFIGMAP_PATH = "/api/v1/namespaces/amazon-cloudwatch/configmaps/cluster-info";
    private static final String AUTH_HEADER_NAME = "Authorization";
    private static final String AUTH_HEADER_TEMPLATE = "Bearer %s";
    private static final int HTTP_TIMEOUT = 5;
    private static final Log logger = LogFactory.getLog(ContainerInsightsUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClusterName() {
        if (ContainerInsightsUtil.isK8s()) {
            String string;
            CloseableHttpClient client = ContainerInsightsUtil.getHttpClient();
            HttpGet getRequest = new HttpGet("https://kubernetes.default.svc/api/v1/namespaces/amazon-cloudwatch/configmaps/cluster-info");
            if (ContainerInsightsUtil.getK8sCredentialHeader() != null) {
                getRequest.setHeader(AUTH_HEADER_NAME, ContainerInsightsUtil.getK8sCredentialHeader());
            }
            CloseableHttpResponse response = client.execute(getRequest);
            try {
                HttpEntity entity = response.getEntity();
                String json = EntityUtils.toString(entity);
                ObjectMapper mapper = new ObjectMapper();
                String clusterName = mapper.readTree(json).at("/data/cluster.name").asText();
                if (logger.isDebugEnabled()) {
                    logger.debug("Container Insights Cluster Name: " + clusterName);
                }
                string = clusterName;
            }
            catch (IOException e) {
                try {
                    try {
                        logger.error("Error parsing response from Kubernetes", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        response.close();
                    }
                    client.close();
                }
                catch (IOException e2) {
                    logger.error("Error querying for Container Insights ConfigMap", e2);
                }
            }
            response.close();
            return string;
        }
        return null;
    }

    private static CloseableHttpClient getHttpClient() {
        KeyStore k8sTrustStore = ContainerInsightsUtil.getK8sKeystore();
        try {
            if (k8sTrustStore != null) {
                TrustManagerFactory trustManagerFactory = null;
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(k8sTrustStore);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers != null) {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(null, trustManagers, new SecureRandom());
                    return HttpClients.custom().setSSLContext(context).build();
                }
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.debug("Unable to create HTTP client with K8s CA certs, using default trust store.", e);
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getK8sKeystore() {
        InputStream certificateFile = null;
        try {
            Object certificateFactory;
            KeyStore k8sTrustStore = null;
            File caFile = Paths.get(K8S_CRED_FOLDER, K8S_CRED_CERT_SUFFIX).toFile();
            if (caFile.exists()) {
                k8sTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                k8sTrustStore.load(null, null);
                certificateFactory = CertificateFactory.getInstance("X.509");
                certificateFile = new FileInputStream(caFile);
                Collection<? extends Certificate> certificates = ((CertificateFactory)certificateFactory).generateCertificates(certificateFile);
                if (certificates.isEmpty()) {
                    throw new IllegalArgumentException("K8s cert file contained no certificates.");
                }
                for (Certificate certificate : certificates) {
                    k8sTrustStore.setCertificateEntry("k8sca", certificate);
                }
            } else {
                logger.debug("K8s CA Cert file does not exists.");
            }
            certificateFactory = k8sTrustStore;
            return certificateFactory;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.warn("Unable to load K8s CA certificate.", e);
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (certificateFile != null) {
                try {
                    certificateFile.close();
                }
                catch (IOException e) {
                    logger.error("Can't close K8s CA certificate file.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getK8sCredentialHeader() {
        BufferedReader tokenReader = null;
        try {
            File tokenFile = Paths.get(K8S_CRED_FOLDER, K8S_CRED_TOKEN_SUFFIX).toFile();
            tokenReader = new BufferedReader(new FileReader(tokenFile));
            String string = String.format(AUTH_HEADER_TEMPLATE, tokenReader.readLine());
            return string;
        }
        catch (IOException e) {
            logger.warn("Unable to read K8s credential file.", e);
        }
        finally {
            if (tokenReader != null) {
                try {
                    tokenReader.close();
                }
                catch (IOException e) {
                    logger.error("Can't close K8s credential file.", e);
                }
            }
        }
        return null;
    }

    public static boolean isK8s() {
        return Paths.get(K8S_CRED_FOLDER, K8S_CRED_TOKEN_SUFFIX).toFile().exists();
    }
}

