/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws.cloudformation;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStackSetOperationRequest;
import com.amazonaws.services.cloudformation.model.StackSetOperation;
import com.amazonaws.services.cloudformation.model.StackSetOperationStatus;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackSetHandler {
    private static final long DEFAULT_SLEEP_INTERVAL = 60000L;
    private Logger logger = LoggerFactory.getLogger(StackSetHandler.class);
    private AmazonCloudFormation cloudFormation;
    private long sleepInterval = 60000L;
    private SleepProvider sleepHandler = Thread::sleep;

    public StackSetHandler(AmazonCloudFormation cloudFormation) {
        this.cloudFormation = cloudFormation;
    }

    public void waitForStackSetOperation(String stackSetName, String operationId) {
        StackSetOperation operation;
        do {
            operation = this.cloudFormation.describeStackSetOperation(new DescribeStackSetOperationRequest().withStackSetName(stackSetName).withOperationId(operationId)).getStackSetOperation();
            switch (StackSetOperationStatus.fromValue(operation.getStatus())) {
                case FAILED: 
                case STOPPED: {
                    this.logger.error("Stack operation {} failed with status {}.", (Object)operationId, (Object)operation.getStatus());
                    throw new IllegalStateException(String.format("Stack operation %s (%s) for stack %s failed with status %s.", operation.getAction(), operationId, operation.getStackSetId(), operation.getStatus()));
                }
                case QUEUED: 
                case RUNNING: 
                case STOPPING: {
                    this.logger.info("Stack operation {} in progress.", (Object)operationId);
                    this.sleep();
                    break;
                }
                case SUCCEEDED: {
                    this.logger.info("Stack operation {} succeeded.", (Object)operationId);
                }
            }
        } while (StackSetOperationStatus.fromValue(operation.getStatus()) != StackSetOperationStatus.SUCCEEDED);
    }

    private void sleep() {
        try {
            this.sleepHandler.sleep(this.sleepInterval);
        }
        catch (InterruptedException error) {
            this.logger.error("Wait interval interrupted.", error);
        }
    }

    @Generated
    public void setSleepInterval(long sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    @Generated
    public void setSleepHandler(SleepProvider sleepHandler) {
        this.sleepHandler = sleepHandler;
    }

    @FunctionalInterface
    public static interface SleepProvider {
        public void sleep(long var1) throws InterruptedException;
    }
}

