/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.lambda.cform.stackset.service;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.CreateStackSetRequest;
import com.amazonaws.services.cloudformation.model.CreateStackSetResult;
import com.amazonaws.services.cloudformation.model.DeleteStackSetRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackSetRequest;
import com.amazonaws.services.cloudformation.model.OperationIdAlreadyExistsException;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackSet;
import com.amazonaws.services.cloudformation.model.StackSetNotFoundException;
import com.amazonaws.services.cloudformation.model.Tag;
import com.amazonaws.services.cloudformation.model.UpdateStackSetRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackSetResult;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.wrzasq.commons.aws.cloudformation.CustomResourceResponse;
import pl.wrzasq.commons.aws.cloudformation.StackSetHandler;
import pl.wrzasq.commons.aws.cloudformation.StackUtils;
import pl.wrzasq.lambda.cform.stackset.model.StackSetRequest;
import pl.wrzasq.lambda.cform.stackset.model.StackSetResponse;

public class StackSetManager {
    private static final String DRIFT_LOG_MESSAGE_PATTERN = "Stack set ID {} differs from CloudFormation-provided physical resource ID {}.";
    private static final Capability[] CAPABILITY_CAST = new Capability[0];
    private Logger logger = LoggerFactory.getLogger(StackSetManager.class);
    private AmazonCloudFormation cloudFormation;
    private StackSetHandler stackSetHandler;

    public StackSetManager(AmazonCloudFormation cloudFormation, StackSetHandler stackSetHandler) {
        this.cloudFormation = cloudFormation;
        this.stackSetHandler = stackSetHandler;
    }

    public CustomResourceResponse<StackSetResponse> deployStackSet(StackSetRequest input, String physicalResourceId) {
        StackSetResponse response = new StackSetResponse();
        try {
            StackSet stackSet = this.cloudFormation.describeStackSet(new DescribeStackSetRequest().withStackSetName(input.getStackSetName())).getStackSet();
            this.logger.info("Stack set already exists (ARN {}).", (Object)stackSet.getStackSetARN());
            this.updateStackSet(input);
            if (!stackSet.getStackSetId().equals(physicalResourceId)) {
                this.logger.warn(DRIFT_LOG_MESSAGE_PATTERN, (Object)stackSet.getStackSetId(), (Object)physicalResourceId);
            }
            response.setId(stackSet.getStackSetId());
        }
        catch (StackSetNotFoundException error) {
            response.setId(this.createStackSet(input));
        }
        response.setStackSetName(input.getStackSetName());
        return new CustomResourceResponse<StackSetResponse>(response, response.getId());
    }

    public CustomResourceResponse<StackSetResponse> deleteStackSet(StackSetRequest input, String physicalResourceId) {
        StackSet stackSet = this.cloudFormation.describeStackSet(new DescribeStackSetRequest().withStackSetName(input.getStackSetName())).getStackSet();
        if (!stackSet.getStackSetId().equals(physicalResourceId)) {
            this.logger.error(DRIFT_LOG_MESSAGE_PATTERN, (Object)stackSet.getStackSetId(), (Object)physicalResourceId);
            throw new IllegalStateException(String.format("Can not delete Stack set - ID %s doesn't match CloudFormation-provided resource ID %s.", stackSet.getStackSetId(), physicalResourceId));
        }
        this.cloudFormation.deleteStackSet(new DeleteStackSetRequest().withStackSetName(input.getStackSetName()));
        this.logger.info("Stack set deleted.");
        return new CustomResourceResponse<Object>(null, physicalResourceId);
    }

    private String createStackSet(StackSetRequest input) {
        CreateStackSetResult result2 = this.cloudFormation.createStackSet(new CreateStackSetRequest().withStackSetName(input.getStackSetName()).withTemplateURL(input.getTemplateUrl()).withDescription(input.getDescription()).withAdministrationRoleARN(input.getAdministrationRoleArn()).withExecutionRoleName(input.getExecutionRoleName()).withCapabilities(input.getCapabilities().toArray(CAPABILITY_CAST)).withParameters(StackSetManager.buildSdkParameters(input)).withTags(StackSetManager.buildSdkTags(input)));
        this.logger.info("Created new stack set, ID {}.", (Object)result2.getStackSetId());
        return result2.getStackSetId();
    }

    private void updateStackSet(StackSetRequest input) {
        int attempt = 0;
        String hash = String.format("hash-%d", List.of(input.getTemplateUrl(), input.getDescription(), input.getAdministrationRoleArn(), input.getExecutionRoleName(), input.getCapabilities(), input.getParameters(), input.getTags()).hashCode());
        while (true) {
            try {
                UpdateStackSetResult result2 = this.cloudFormation.updateStackSet(new UpdateStackSetRequest().withStackSetName(input.getStackSetName()).withOperationId(String.format("%s-%d", hash, attempt)).withTemplateURL(input.getTemplateUrl()).withDescription(input.getDescription()).withAdministrationRoleARN(input.getAdministrationRoleArn()).withExecutionRoleName(input.getExecutionRoleName()).withCapabilities(input.getCapabilities().toArray(CAPABILITY_CAST)).withParameters(StackSetManager.buildSdkParameters(input)).withTags(StackSetManager.buildSdkTags(input)));
                this.stackSetHandler.waitForStackSetOperation(input.getStackSetName(), result2.getOperationId());
                this.logger.info("Updated stack set (operation ID: {}).", (Object)result2.getOperationId());
                return;
            }
            catch (OperationIdAlreadyExistsException error) {
                this.logger.info("ID already used, trying next attempt.");
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static Collection<Parameter> buildSdkParameters(StackSetRequest input) {
        return StackUtils.buildSdkList(input.getParameters(), (key, value) -> new Parameter().withParameterKey((String)key).withParameterValue((String)value));
    }

    private static Collection<Tag> buildSdkTags(StackSetRequest input) {
        return StackUtils.buildSdkList(input.getTags(), (key, value) -> new Tag().withKey((String)key).withValue((String)value));
    }
}

