/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.client.impl;

import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.DelegatingDnsResolver;
import com.amazonaws.http.SystemPropertyTlsKeyManagersProvider;
import com.amazonaws.http.TlsKeyManagersProvider;
import com.amazonaws.http.client.ConnectionManagerFactory;
import com.amazonaws.http.conn.SdkPlainSocketFactory;
import com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.internal.SdkSSLContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class ApacheConnectionManagerFactory
implements ConnectionManagerFactory<HttpClientConnectionManager> {
    private final Log LOG = LogFactory.getLog(AmazonHttpClient.class);

    @Override
    public HttpClientConnectionManager create(HttpClientSettings settings2) {
        ConnectionSocketFactory sslsf = this.getPreferredSocketFactory(settings2);
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry(sslsf), null, DefaultSchemePortResolver.INSTANCE, new DelegatingDnsResolver(settings2.getDnsResolver()), settings2.getConnectionPoolTTL(), TimeUnit.MILLISECONDS);
        cm.setValidateAfterInactivity(settings2.getValidateAfterInactivityMillis());
        cm.setDefaultMaxPerRoute(settings2.getMaxConnections());
        cm.setMaxTotal(settings2.getMaxConnections());
        cm.setDefaultSocketConfig(this.buildSocketConfig(settings2));
        cm.setDefaultConnectionConfig(this.buildConnectionConfig(settings2));
        return cm;
    }

    private ConnectionSocketFactory getPreferredSocketFactory(HttpClientSettings settings2) {
        ConnectionSocketFactory sslsf = settings2.getApacheHttpClientConfig().getSslSocketFactory();
        return sslsf != null ? sslsf : new SdkTLSSocketFactory(SdkSSLContext.getPreferredSSLContext(this.getKeyManagers(settings2), settings2.getSecureRandom()), this.getHostNameVerifier(settings2));
    }

    private SocketConfig buildSocketConfig(HttpClientSettings settings2) {
        return SocketConfig.custom().setSoKeepAlive(settings2.useTcpKeepAlive()).setSoTimeout(settings2.getSocketTimeout()).setTcpNoDelay(true).build();
    }

    private ConnectionConfig buildConnectionConfig(HttpClientSettings settings2) {
        int socketBufferSize = Math.max(settings2.getSocketBufferSize()[0], settings2.getSocketBufferSize()[1]);
        return socketBufferSize <= 0 ? null : ConnectionConfig.custom().setBufferSize(socketBufferSize).build();
    }

    private KeyManager[] getKeyManagers(HttpClientSettings settings2) {
        TlsKeyManagersProvider provider = settings2.getTlsKeyMangersProvider();
        if (provider == null) {
            provider = new SystemPropertyTlsKeyManagersProvider();
        }
        return provider.getKeyManagers();
    }

    private HostnameVerifier getHostNameVerifier(HttpClientSettings options2) {
        return options2.useBrowserCompatibleHostNameVerifier() ? SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory sslSocketFactory) {
        if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
            if (this.LOG.isWarnEnabled()) {
                this.LOG.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
            }
            sslSocketFactory = new TrustingSocketFactory();
        }
        return RegistryBuilder.create().register("http", new SdkPlainSocketFactory()).register("https", (SdkPlainSocketFactory)sslSocketFactory).build();
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements LayeredConnectionSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return context;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, target, port, true);
        }

        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        @Override
        public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket(context));
            if (localAddress != null) {
                sslsock.bind(localAddress);
            }
            sslsock.connect(remoteAddress, connectTimeout);
            return sslsock;
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }
    }
}

