/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ResourceIdentifierSummary
implements Serializable,
Cloneable {
    private String resourceType;
    private SdkInternalList<String> logicalResourceIds;
    private SdkInternalList<String> resourceIdentifiers;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceIdentifierSummary withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<String> getLogicalResourceIds() {
        if (this.logicalResourceIds == null) {
            this.logicalResourceIds = new SdkInternalList();
        }
        return this.logicalResourceIds;
    }

    public void setLogicalResourceIds(Collection<String> logicalResourceIds) {
        if (logicalResourceIds == null) {
            this.logicalResourceIds = null;
            return;
        }
        this.logicalResourceIds = new SdkInternalList<String>(logicalResourceIds);
    }

    public ResourceIdentifierSummary withLogicalResourceIds(String ... logicalResourceIds) {
        if (this.logicalResourceIds == null) {
            this.setLogicalResourceIds(new SdkInternalList<String>(logicalResourceIds.length));
        }
        for (String ele : logicalResourceIds) {
            this.logicalResourceIds.add(ele);
        }
        return this;
    }

    public ResourceIdentifierSummary withLogicalResourceIds(Collection<String> logicalResourceIds) {
        this.setLogicalResourceIds(logicalResourceIds);
        return this;
    }

    public List<String> getResourceIdentifiers() {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new SdkInternalList();
        }
        return this.resourceIdentifiers;
    }

    public void setResourceIdentifiers(Collection<String> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        this.resourceIdentifiers = new SdkInternalList<String>(resourceIdentifiers);
    }

    public ResourceIdentifierSummary withResourceIdentifiers(String ... resourceIdentifiers) {
        if (this.resourceIdentifiers == null) {
            this.setResourceIdentifiers(new SdkInternalList<String>(resourceIdentifiers.length));
        }
        for (String ele : resourceIdentifiers) {
            this.resourceIdentifiers.add(ele);
        }
        return this;
    }

    public ResourceIdentifierSummary withResourceIdentifiers(Collection<String> resourceIdentifiers) {
        this.setResourceIdentifiers(resourceIdentifiers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getLogicalResourceIds() != null) {
            sb.append("LogicalResourceIds: ").append(this.getLogicalResourceIds()).append(",");
        }
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: ").append(this.getResourceIdentifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifierSummary)) {
            return false;
        }
        ResourceIdentifierSummary other = (ResourceIdentifierSummary)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getLogicalResourceIds() == null ^ this.getLogicalResourceIds() == null) {
            return false;
        }
        if (other.getLogicalResourceIds() != null && !other.getLogicalResourceIds().equals(this.getLogicalResourceIds())) {
            return false;
        }
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        return other.getResourceIdentifiers() == null || other.getResourceIdentifiers().equals(this.getResourceIdentifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getLogicalResourceIds() == null ? 0 : this.getLogicalResourceIds().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        return hashCode2;
    }

    public ResourceIdentifierSummary clone() {
        try {
            return (ResourceIdentifierSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

