/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sns.message.SignatureVerifier;
import com.amazonaws.services.sns.message.SnsMessage;
import com.amazonaws.services.sns.message.SnsMessageHandler;
import com.amazonaws.services.sns.message.SnsMessageUnmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class SnsMessageManager {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final HttpClient client = HttpClientBuilder.create().build();
    private final SignatureVerifier signatureVerifier;
    private final SnsMessageUnmarshaller messageUnmarshaller;
    private final String endpoint;

    public SnsMessageManager() {
        this(new DefaultAwsRegionProviderChain().getRegion());
    }

    public SnsMessageManager(String region) {
        this.endpoint = RegionUtils.getRegion(region).getServiceEndpoint("sns");
        this.signatureVerifier = new SignatureVerifier(this.client, this.endpoint, this.resolveCertCommonName(region));
        this.messageUnmarshaller = new SnsMessageUnmarshaller(this.client);
    }

    @SdkTestInternalApi
    SnsMessageManager(String region, SignatureVerifier signatureVerifier) {
        this.endpoint = RegionUtils.getRegion(region).getServiceEndpoint("sns");
        this.signatureVerifier = signatureVerifier;
        this.messageUnmarshaller = new SnsMessageUnmarshaller(this.client);
    }

    public SnsMessage parseMessage(InputStream messageBody) {
        JsonNode messageJson = this.toJson(messageBody);
        this.signatureVerifier.verifySignature(messageJson);
        return this.messageUnmarshaller.unmarshall(messageJson);
    }

    public void handleMessage(InputStream messageBody, SnsMessageHandler handler) {
        this.parseMessage(messageBody).handle(handler);
    }

    private JsonNode toJson(InputStream messageBody) {
        try {
            return MAPPER.readTree(messageBody);
        }
        catch (IOException e) {
            throw new SdkClientException("Could not parse message as JSON.", e);
        }
    }

    private String resolveCertCommonName(String region) {
        if (Regions.CN_NORTH_1.getName().equals(region)) {
            return "sns-cn-north-1.amazonaws.com.cn";
        }
        if (Regions.CN_NORTHWEST_1.getName().equals(region)) {
            return "sns-cn-northwest-1.amazonaws.com.cn";
        }
        if (Regions.GovCloud.getName().equals(region)) {
            return "sns-us-gov-west-1.amazonaws.com";
        }
        if (Regions.US_GOV_EAST_1.getName().equals(region)) {
            return "sns-us-gov-west-1.amazonaws.com";
        }
        return "sns." + RegionUtils.getRegion(region).getDomain();
    }
}

