/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.xray.model.TraceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetTraceSummariesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<TraceSummary> traceSummaries;
    private Date approximateTime;
    private Long tracesProcessedCount;
    private String nextToken;

    public List<TraceSummary> getTraceSummaries() {
        return this.traceSummaries;
    }

    public void setTraceSummaries(Collection<TraceSummary> traceSummaries) {
        if (traceSummaries == null) {
            this.traceSummaries = null;
            return;
        }
        this.traceSummaries = new ArrayList<TraceSummary>(traceSummaries);
    }

    public GetTraceSummariesResult withTraceSummaries(TraceSummary ... traceSummaries) {
        if (this.traceSummaries == null) {
            this.setTraceSummaries(new ArrayList<TraceSummary>(traceSummaries.length));
        }
        for (TraceSummary ele : traceSummaries) {
            this.traceSummaries.add(ele);
        }
        return this;
    }

    public GetTraceSummariesResult withTraceSummaries(Collection<TraceSummary> traceSummaries) {
        this.setTraceSummaries(traceSummaries);
        return this;
    }

    public void setApproximateTime(Date approximateTime) {
        this.approximateTime = approximateTime;
    }

    public Date getApproximateTime() {
        return this.approximateTime;
    }

    public GetTraceSummariesResult withApproximateTime(Date approximateTime) {
        this.setApproximateTime(approximateTime);
        return this;
    }

    public void setTracesProcessedCount(Long tracesProcessedCount) {
        this.tracesProcessedCount = tracesProcessedCount;
    }

    public Long getTracesProcessedCount() {
        return this.tracesProcessedCount;
    }

    public GetTraceSummariesResult withTracesProcessedCount(Long tracesProcessedCount) {
        this.setTracesProcessedCount(tracesProcessedCount);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetTraceSummariesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTraceSummaries() != null) {
            sb.append("TraceSummaries: ").append(this.getTraceSummaries()).append(",");
        }
        if (this.getApproximateTime() != null) {
            sb.append("ApproximateTime: ").append(this.getApproximateTime()).append(",");
        }
        if (this.getTracesProcessedCount() != null) {
            sb.append("TracesProcessedCount: ").append(this.getTracesProcessedCount()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTraceSummariesResult)) {
            return false;
        }
        GetTraceSummariesResult other = (GetTraceSummariesResult)obj;
        if (other.getTraceSummaries() == null ^ this.getTraceSummaries() == null) {
            return false;
        }
        if (other.getTraceSummaries() != null && !other.getTraceSummaries().equals(this.getTraceSummaries())) {
            return false;
        }
        if (other.getApproximateTime() == null ^ this.getApproximateTime() == null) {
            return false;
        }
        if (other.getApproximateTime() != null && !other.getApproximateTime().equals(this.getApproximateTime())) {
            return false;
        }
        if (other.getTracesProcessedCount() == null ^ this.getTracesProcessedCount() == null) {
            return false;
        }
        if (other.getTracesProcessedCount() != null && !other.getTracesProcessedCount().equals(this.getTracesProcessedCount())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getTraceSummaries() == null ? 0 : this.getTraceSummaries().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getApproximateTime() == null ? 0 : this.getApproximateTime().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getTracesProcessedCount() == null ? 0 : this.getTracesProcessedCount().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode2;
    }

    public GetTraceSummariesResult clone() {
        try {
            return (GetTraceSummariesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

