/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.javax.servlet;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.javax.servlet.AWSXRayServletFilter;
import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

class AWSXRayServletAsyncListener
implements AsyncListener {
    public static final String ENTITY_ATTRIBUTE_KEY = "com.amazonaws.xray.entities.Entity";
    private AWSXRayRecorder recorder;
    private AWSXRayServletFilter filter;

    public AWSXRayServletAsyncListener(AWSXRayServletFilter filter, AWSXRayRecorder recorder) {
        this.filter = filter;
        this.recorder = recorder;
    }

    private AWSXRayRecorder getRecorder() {
        if (this.recorder == null) {
            this.recorder = AWSXRay.getGlobalRecorder();
        }
        return this.recorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(AsyncEvent event) throws IOException {
        AWSXRayRecorder recorder = this.getRecorder();
        Entity prior = recorder.getTraceEntity();
        try {
            Entity entity = (Entity)event.getSuppliedRequest().getAttribute(ENTITY_ATTRIBUTE_KEY);
            recorder.setTraceEntity(entity);
            if (null != event.getThrowable()) {
                entity.addException(event.getThrowable());
            }
            this.filter.postFilter(event.getSuppliedRequest(), event.getSuppliedResponse());
        }
        finally {
            recorder.setTraceEntity(prior);
        }
    }

    public void onComplete(AsyncEvent event) throws IOException {
        this.processEvent(event);
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        this.processEvent(event);
    }

    public void onError(AsyncEvent event) throws IOException {
        this.processEvent(event);
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }
}

