/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.javax.servlet;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.StringValidator;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.javax.servlet.AWSXRayServletAsyncListener;
import com.amazonaws.xray.strategy.DynamicSegmentNamingStrategy;
import com.amazonaws.xray.strategy.FixedSegmentNamingStrategy;
import com.amazonaws.xray.strategy.SegmentNamingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingRequest;
import com.amazonaws.xray.strategy.sampling.SamplingResponse;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayServletFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(AWSXRayServletFilter.class);
    private String segmentOverrideName;
    private String segmentDefaultName;
    private SegmentNamingStrategy segmentNamingStrategy;
    private AWSXRayRecorder recorder;
    private AWSXRayServletAsyncListener listener;

    public AWSXRayServletFilter() {
        this((SegmentNamingStrategy)null);
    }

    public AWSXRayServletFilter(String fixedSegmentName) {
        this(new FixedSegmentNamingStrategy(fixedSegmentName));
    }

    public AWSXRayServletFilter(SegmentNamingStrategy segmentNamingStrategy) {
        this(segmentNamingStrategy, null);
    }

    public AWSXRayServletFilter(SegmentNamingStrategy segmentNamingStrategy, AWSXRayRecorder recorder) {
        this.segmentNamingStrategy = segmentNamingStrategy;
        this.recorder = recorder;
        this.listener = new AWSXRayServletAsyncListener(this, recorder);
    }

    public String getSegmentOverrideName() {
        return this.segmentOverrideName;
    }

    public void setSegmentOverrideName(String segmentOverrideName) {
        this.segmentOverrideName = segmentOverrideName;
    }

    public String getSegmentDefaultName() {
        return this.segmentDefaultName;
    }

    public void setSegmentDefaultName(String segmentDefaultName) {
        this.segmentDefaultName = segmentDefaultName;
    }

    public void init(FilterConfig config) throws ServletException {
        String fixedName = config.getInitParameter("fixedName");
        String dynamicNamingFallbackName = config.getInitParameter("dynamicNamingFallbackName");
        String dynamicNamingRecognizedHosts = config.getInitParameter("dynamicNamingRecognizedHosts");
        if (StringValidator.isNotNullOrBlank(dynamicNamingFallbackName)) {
            this.segmentNamingStrategy = StringValidator.isNotNullOrBlank(dynamicNamingRecognizedHosts) ? new DynamicSegmentNamingStrategy(dynamicNamingFallbackName, dynamicNamingRecognizedHosts) : new DynamicSegmentNamingStrategy(dynamicNamingFallbackName);
        } else if (StringValidator.isNotNullOrBlank(fixedName)) {
            this.segmentNamingStrategy = new FixedSegmentNamingStrategy(fixedName);
        } else if (null == this.segmentNamingStrategy) {
            throw new ServletException("The AWSXRayServletFilter requires either a fixedName init-param or an instance of SegmentNamingStrategy. Add an init-param tag to the AWSXRayServletFilter's declaration in web.xml, using param-name: 'fixedName'. Alternatively, pass an instance of SegmentNamingStrategy to the AWSXRayServletFilter constructor.");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("AWSXRayServletFilter is beginning to process request: " + request.toString());
        }
        Segment segment = this.preFilter(request, response);
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            if (null != segment) {
                segment.addException(e);
            }
            throw e;
        }
        finally {
            if (request.isAsyncStarted()) {
                request.setAttribute("com.amazonaws.xray.entities.Entity", (Object)segment);
                try {
                    request.getAsyncContext().addListener((AsyncListener)this.listener);
                    this.recorder.clearTraceEntity();
                }
                catch (IllegalStateException ise) {
                    this.postFilter(request, response);
                }
            } else {
                this.postFilter(request, response);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("AWSXRayServletFilter is finished processing request: " + request.toString());
            }
        }
    }

    private HttpServletRequest castServletRequest(ServletRequest request) {
        try {
            return (HttpServletRequest)request;
        }
        catch (ClassCastException cce) {
            logger.warn("Unable to cast ServletRequest to HttpServletRequest.", cce);
            return null;
        }
    }

    private HttpServletResponse castServletResponse(ServletResponse response) {
        try {
            return (HttpServletResponse)response;
        }
        catch (ClassCastException cce) {
            logger.warn("Unable to cast ServletResponse to HttpServletResponse.", cce);
            return null;
        }
    }

    private Optional<TraceHeader> getTraceHeader(HttpServletRequest request) {
        String traceHeaderString = request.getHeader("X-Amzn-Trace-Id");
        if (null != traceHeaderString) {
            return Optional.of(TraceHeader.fromString(traceHeaderString));
        }
        return Optional.empty();
    }

    private Optional<String> getHost(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Host"));
    }

    private Optional<String> getClientIp(HttpServletRequest request) {
        return Optional.ofNullable(request.getRemoteAddr());
    }

    private Optional<String> getXForwardedFor(HttpServletRequest request) {
        String forwarded = null;
        forwarded = request.getHeader("X-Forwarded-For");
        if (forwarded != null) {
            return Optional.of(forwarded.split(",")[0].trim());
        }
        return Optional.empty();
    }

    private Optional<String> getUserAgent(HttpServletRequest request) {
        String userAgentHeaderString = request.getHeader("User-Agent");
        if (null != userAgentHeaderString) {
            return Optional.of(userAgentHeaderString);
        }
        return Optional.empty();
    }

    private Optional<Integer> getContentLength(HttpServletResponse response) {
        String contentLengthString = response.getHeader("Content-Length");
        if (null != contentLengthString && !contentLengthString.isEmpty()) {
            try {
                return Optional.of(Integer.parseInt(contentLengthString));
            }
            catch (NumberFormatException nfe) {
                logger.debug("Unable to parse Content-Length header from HttpServletResponse.", nfe);
            }
        }
        return Optional.empty();
    }

    private String getSegmentName(HttpServletRequest httpServletRequest) {
        try {
            return this.segmentNamingStrategy.nameForRequest(httpServletRequest);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("The AWSXRayServletFilter requires either a fixedName init-param or an instance of SegmentNamingStrategy. Add an init-param tag to the AWSXRayServletFilter's declaration in web.xml, using param-name: 'fixedName'. Alternatively, pass an instance of SegmentNamingStrategy to the AWSXRayServletFilter constructor.", npe);
        }
    }

    private SamplingResponse fromSamplingStrategy(HttpServletRequest httpServletRequest) {
        AWSXRayRecorder recorder = this.getRecorder();
        SamplingRequest samplingRequest = new SamplingRequest(this.getSegmentName(httpServletRequest), this.getHost(httpServletRequest).orElse(null), httpServletRequest.getRequestURI(), httpServletRequest.getMethod(), recorder.getOrigin());
        SamplingResponse sample = recorder.getSamplingStrategy().shouldTrace(samplingRequest);
        return sample;
    }

    private TraceHeader.SampleDecision getSampleDecision(SamplingResponse sample) {
        if (sample.isSampled()) {
            logger.debug("Sampling strategy decided SAMPLED.");
            return TraceHeader.SampleDecision.SAMPLED;
        }
        logger.debug("Sampling strategy decided NOT_SAMPLED.");
        return TraceHeader.SampleDecision.NOT_SAMPLED;
    }

    private AWSXRayRecorder getRecorder() {
        if (this.recorder == null) {
            this.recorder = AWSXRay.getGlobalRecorder();
        }
        return this.recorder;
    }

    public Segment preFilter(ServletRequest request, ServletResponse response) {
        Optional<String> xForwardedFor;
        String parentId;
        TraceID traceId;
        TraceHeader.SampleDecision sampleDecision;
        AWSXRayRecorder recorder = this.getRecorder();
        Segment created = null;
        HttpServletRequest httpServletRequest = this.castServletRequest(request);
        if (null == httpServletRequest) {
            logger.warn("Null value for incoming HttpServletRequest. Beginning DummySegment.");
            return recorder.beginDummySegment(new TraceID());
        }
        Optional<TraceHeader> incomingHeader = this.getTraceHeader(httpServletRequest);
        SamplingStrategy samplingStrategy = recorder.getSamplingStrategy();
        if (logger.isDebugEnabled() && incomingHeader.isPresent()) {
            logger.debug("Incoming trace header received: " + incomingHeader.get().toString());
        }
        SamplingResponse samplingResponse = this.fromSamplingStrategy(httpServletRequest);
        TraceHeader.SampleDecision sampleDecision2 = sampleDecision = incomingHeader.isPresent() ? incomingHeader.get().getSampled() : this.getSampleDecision(samplingResponse);
        if (TraceHeader.SampleDecision.REQUESTED.equals((Object)sampleDecision) || TraceHeader.SampleDecision.UNKNOWN.equals((Object)sampleDecision)) {
            sampleDecision = this.getSampleDecision(samplingResponse);
        }
        TraceID traceID = traceId = incomingHeader.isPresent() ? incomingHeader.get().getRootTraceId() : null;
        if (null == traceId) {
            traceId = new TraceID();
        }
        String string = parentId = incomingHeader.isPresent() ? incomingHeader.get().getParentId() : null;
        if (TraceHeader.SampleDecision.SAMPLED.equals((Object)sampleDecision)) {
            created = recorder.beginSegment(this.getSegmentName(httpServletRequest), traceId, parentId);
            if (samplingResponse.getRuleName().isPresent()) {
                logger.debug("Sampling strategy decided to use rule named: " + samplingResponse.getRuleName().get() + ".");
                created.setRuleName(samplingResponse.getRuleName().get());
            }
        } else if (samplingStrategy.isForcedSamplingSupported()) {
            created = recorder.beginSegment(this.getSegmentName(httpServletRequest), traceId, parentId);
            created.setSampled(false);
        } else {
            logger.debug("Creating Dummy Segment");
            created = recorder.beginDummySegment(this.getSegmentName(httpServletRequest), traceId);
        }
        HashMap<String, Object> requestAttributes = new HashMap<String, Object>();
        requestAttributes.put("url", httpServletRequest.getRequestURL().toString());
        requestAttributes.put("method", httpServletRequest.getMethod());
        Optional<String> userAgent = this.getUserAgent(httpServletRequest);
        if (userAgent.isPresent()) {
            requestAttributes.put("user_agent", userAgent.get());
        }
        if ((xForwardedFor = this.getXForwardedFor(httpServletRequest)).isPresent()) {
            requestAttributes.put("client_ip", xForwardedFor.get());
            requestAttributes.put("x_forwarded_for", true);
        } else {
            Optional<String> clientIp = this.getClientIp(httpServletRequest);
            if (clientIp.isPresent()) {
                requestAttributes.put("client_ip", clientIp.get());
            }
        }
        created.putHttp("request", requestAttributes);
        HttpServletResponse httpServletResponse = this.castServletResponse(response);
        if (null == response) {
            return created;
        }
        TraceHeader responseHeader = null;
        if (incomingHeader.isPresent()) {
            responseHeader = new TraceHeader(created.getTraceId());
            if (TraceHeader.SampleDecision.REQUESTED == incomingHeader.get().getSampled()) {
                responseHeader.setSampled(created.isSampled() ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED);
            }
        } else {
            responseHeader = new TraceHeader(created.getTraceId());
        }
        httpServletResponse.addHeader("X-Amzn-Trace-Id", responseHeader.toString());
        return created;
    }

    public void postFilter(ServletRequest request, ServletResponse response) {
        AWSXRayRecorder recorder = this.getRecorder();
        Segment segment = recorder.getCurrentSegment();
        if (null != segment) {
            HttpServletResponse httpServletResponse = this.castServletResponse(response);
            if (null != httpServletResponse) {
                HashMap<String, Integer> responseAttributes = new HashMap<String, Integer>();
                int responseCode = httpServletResponse.getStatus();
                switch (responseCode / 100) {
                    case 4: {
                        segment.setError(true);
                        if (responseCode != 429) break;
                        segment.setThrottle(true);
                        break;
                    }
                    case 5: {
                        segment.setFault(true);
                        break;
                    }
                }
                responseAttributes.put("status", responseCode);
                Optional<Integer> contentLength = this.getContentLength(httpServletResponse);
                if (contentLength.isPresent()) {
                    responseAttributes.put("content_length", contentLength.get());
                }
                segment.putHttp("response", responseAttributes);
            }
            recorder.endSegment();
        }
    }
}

