/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling.reservoir;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Reservoir {
    static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final int NANOS_PER_DECISECOND = (int)(NANOS_PER_SECOND / 10L);
    private final int tracesPerSecond;
    private final MaxFunction maxFunction;
    private final AtomicInteger usage = new AtomicInteger(0);
    private final AtomicLong nextReset;

    public Reservoir() {
        this(0);
    }

    public Reservoir(int tracesPerSecond) {
        this.tracesPerSecond = tracesPerSecond;
        this.maxFunction = tracesPerSecond < 10 ? new LessThan10(tracesPerSecond) : new AtLeast10(tracesPerSecond);
        long now = System.nanoTime();
        this.nextReset = new AtomicLong(now + NANOS_PER_SECOND);
    }

    public boolean take() {
        int next;
        int prev;
        boolean shouldReset;
        long updateAt;
        long now = System.nanoTime();
        long nanosUntilReset = -(now - (updateAt = this.nextReset.get()));
        boolean bl = shouldReset = nanosUntilReset <= 0L;
        if (shouldReset && this.nextReset.compareAndSet(updateAt, now + NANOS_PER_SECOND)) {
            this.usage.set(0);
        }
        int max = this.maxFunction.max(shouldReset ? 0L : nanosUntilReset);
        do {
            if ((next = (prev = this.usage.get()) + 1) <= max) continue;
            return false;
        } while (!this.usage.compareAndSet(prev, next));
        return true;
    }

    public int getTracesPerSecond() {
        return this.tracesPerSecond;
    }

    static final class AtLeast10
    extends MaxFunction {
        final int[] max;

        AtLeast10(int tracesPerSecond) {
            int tracesPerDecisecond = tracesPerSecond / 10;
            int remainder = tracesPerSecond % 10;
            this.max = new int[10];
            this.max[0] = tracesPerDecisecond + remainder;
            for (int i = 1; i < 10; ++i) {
                this.max[i] = this.max[i - 1] + tracesPerDecisecond;
            }
        }

        @Override
        int max(long nanosUntilReset) {
            if (nanosUntilReset == 0L) {
                return this.max[0];
            }
            int decisecondsUntilReset = Math.max((int)nanosUntilReset / NANOS_PER_DECISECOND, 1);
            int index = 10 - decisecondsUntilReset;
            return this.max[index];
        }
    }

    static final class LessThan10
    extends MaxFunction {
        final int tracesPerSecond;

        LessThan10(int tracesPerSecond) {
            this.tracesPerSecond = tracesPerSecond;
        }

        @Override
        int max(long nanosUntilReset) {
            return this.tracesPerSecond;
        }
    }

    static abstract class MaxFunction {
        MaxFunction() {
        }

        abstract int max(long var1);
    }
}

