/*
 * Decompiled with CFR 0.152.
 */
package com.sunrun.cfnresponse;

import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.sunrun.cfnresponse.CfnRequest;
import com.sunrun.cfnresponse.CfnResponse;
import com.sunrun.cfnresponse.Status;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfnResponseSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(CfnResponseSender.class);
    private final ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
    private final HttpClient httpClient;

    public CfnResponseSender() {
        this.httpClient = HttpClientBuilder.create().build();
    }

    CfnResponseSender(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public <T> boolean send(@Nonnull CfnRequest<?> event, @Nonnull Status status, @Nonnull Context context, @Nullable String reason, @Nullable T data2, @Nullable String physicalResourceId) {
        return this.send(event, status, context, reason, data2, physicalResourceId, false);
    }

    public <T> boolean send(@Nonnull CfnRequest<?> event, @Nonnull Status status, @Nonnull Context context, @Nullable String reason, @Nullable T data2, @Nullable String physicalResourceId, boolean noEcho) {
        this.checkNotNull(event, "event");
        this.checkNotNull((Object)status, "status");
        this.checkNotNull(context, "context");
        CfnResponse<T> response = new CfnResponse<T>();
        response.setData(data2);
        response.setStatus(status);
        response.setLogicalResourceId(event.getLogicalResourceId());
        response.setPhysicalResourceId(physicalResourceId == null ? context.getLogStreamName() : physicalResourceId);
        response.setReason(reason == null ? "See the details in CloudWatch Log Stream: " + context.getLogStreamName() : reason);
        response.setRequestId(event.getRequestId());
        response.setStackId(event.getStackId());
        response.setNoEcho(noEcho);
        HttpPut put = new HttpPut(event.getResponseURL());
        try {
            String body = this.mapper.writeValueAsString(response);
            LOGGER.info(body);
            put.setEntity(new StringEntity(body));
            put.setHeader("Content-Type", "");
            this.httpClient.execute((HttpUriRequest)put, new BasicResponseHandler());
        }
        catch (IOException e) {
            LOGGER.error("Could not send response to " + event.getResponseURL(), e);
            return false;
        }
        return true;
    }

    private <T> void checkNotNull(Object param, String name) {
        if (param == null) {
            throw new IllegalArgumentException("param " + name + " cannot be null.");
        }
    }
}

