/*
 * Decompiled with CFR 0.152.
 */
package pl.wrzasq.commons.aws.cloudformation.macro;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TemplateUtils {
    public static final String SECTION_PARAMETERS = "Parameters";
    public static final String SECTION_CONDITIONS = "Conditions";
    public static final String SECTION_RESOURCES = "Resources";
    public static final String PROPERTY_KEY_TYPE = "Type";
    public static final String PROPERTY_KEY_DEPENDSON = "DependsOn";
    public static final String PROPERTY_KEY_CONDITION = "Condition";
    public static final String PROPERTY_KEY_PROPERTIES = "Properties";

    public static void popProperty(Map<String, Object> properties2, String key, Consumer<Object> then2, Object defaultValue) {
        if (properties2.containsKey(key)) {
            then2.accept(properties2.get(key));
            properties2.remove(key);
        } else if (defaultValue != null) {
            then2.accept(defaultValue);
        }
    }

    public static Map<String, Object> generateResource(String type2, Map<String, Object> properties2, String condition) {
        HashMap<String, Object> resource = new HashMap<String, Object>();
        resource.put(PROPERTY_KEY_TYPE, String.format("AWS::%s", type2));
        if (!properties2.isEmpty()) {
            resource.put(PROPERTY_KEY_PROPERTIES, properties2);
        }
        if (condition != null && !condition.isEmpty()) {
            resource.put(PROPERTY_KEY_CONDITION, condition);
        }
        return resource;
    }

    public static Map<String, Object> ref(String reference) {
        return Collections.singletonMap("Ref", reference);
    }

    public static Map<String, Object> getAtt(String resource, String attribute) {
        return Collections.singletonMap("Fn::GetAtt", Arrays.asList(resource, attribute));
    }

    public static Map<String, Object> sub(Object params) {
        return Collections.singletonMap("Fn::Sub", params);
    }

    public static Map<String, Object> asMap(Object value) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                output.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return output;
    }
}

