/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.flextrade.jfixture.JFixture;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.HIST;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class HISTTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        String link = (String)this.fixture.create(String.class);
        LocalDate date = (LocalDate)this.fixture.create(LocalDate.class);
        String feed = (String)this.fixture.create(String.class);
        String version = (String)this.fixture.create(String.class);
        String protocol = (String)this.fixture.create(String.class);
        String size = (String)this.fixture.create(String.class);
        HIST hist = new HIST(link, date, feed, version, protocol, size);
        Assertions.assertThat((String)hist.getLink()).isEqualTo((Object)link);
        Assertions.assertThat((LocalDate)hist.getDate()).isEqualTo((Object)date);
        Assertions.assertThat((String)hist.getFeed()).isEqualTo((Object)feed);
        Assertions.assertThat((String)hist.getVersion()).isEqualTo((Object)version);
        Assertions.assertThat((String)hist.getProtocol()).isEqualTo((Object)protocol);
        Assertions.assertThat((String)hist.getSize()).isEqualTo((Object)size);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(HIST.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(HIST.class)).verify();
    }
}

