/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.OfficialPrice;
import pl.zankowski.iextrading4j.api.marketdata.PriceType;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class OfficialPriceTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        PriceType priceType = (PriceType)this.fixture.create(PriceType.class);
        BigDecimal price = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long timestamp = (Long)this.fixture.create(Long.class);
        OfficialPrice officialPrice = new OfficialPrice(priceType, price, timestamp);
        Assertions.assertThat((Comparable)officialPrice.getPriceType()).isEqualTo((Object)priceType);
        Assertions.assertThat((BigDecimal)officialPrice.getPrice()).isEqualTo((Object)price);
        Assertions.assertThat((Long)officialPrice.getTimestamp()).isEqualTo((Object)timestamp);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(OfficialPrice.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(OfficialPrice.class)).verify();
    }
}

