/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.Trade;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class TradeTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal price = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal size = (BigDecimal)this.fixture.create(BigDecimal.class);
        Long tradeId = (Long)this.fixture.create(Long.class);
        Boolean isISO = (Boolean)this.fixture.create(Boolean.class);
        Boolean isOddLot = (Boolean)this.fixture.create(Boolean.class);
        Boolean isOutsideRegularHours = (Boolean)this.fixture.create(Boolean.class);
        Boolean isSinglePriceCross = (Boolean)this.fixture.create(Boolean.class);
        Boolean isTradeThroughExample = (Boolean)this.fixture.create(Boolean.class);
        Long timestamp = (Long)this.fixture.create(Long.class);
        Trade trade = new Trade(price, size, tradeId, isISO, isOddLot, isOutsideRegularHours, isSinglePriceCross, isTradeThroughExample, timestamp);
        Assertions.assertThat((BigDecimal)trade.getPrice()).isEqualTo((Object)price);
        Assertions.assertThat((BigDecimal)trade.getSize()).isEqualTo((Object)size);
        Assertions.assertThat((Long)trade.getTradeId()).isEqualTo((Object)tradeId);
        Assertions.assertThat((Boolean)trade.isISO()).isEqualTo((Object)isISO);
        Assertions.assertThat((Boolean)trade.isOddLot()).isEqualTo((Object)isOddLot);
        Assertions.assertThat((Boolean)trade.isOutsideRegularHours()).isEqualTo((Object)isOutsideRegularHours);
        Assertions.assertThat((Boolean)trade.isSinglePriceCross()).isEqualTo((Object)isSinglePriceCross);
        Assertions.assertThat((Boolean)trade.isTradeThroughExempt()).isEqualTo((Object)isTradeThroughExample);
        Assertions.assertThat((Long)trade.getTimestamp()).isEqualTo((Object)timestamp);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Trade.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Trade.class)).verify();
    }
}

