/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.refdata;

import com.flextrade.jfixture.JFixture;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.refdata.ExchangeSymbol;
import pl.zankowski.iextrading4j.api.refdata.SymbolType;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class ExchangeSymbolTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        String symbol = (String)this.fixture.create(String.class);
        String name = (String)this.fixture.create(String.class);
        LocalDate date = (LocalDate)this.fixture.create(LocalDate.class);
        Boolean isEnabled = (Boolean)this.fixture.create(Boolean.class);
        SymbolType type = (SymbolType)this.fixture.create(SymbolType.class);
        Long iexId = (Long)this.fixture.create(Long.class);
        ExchangeSymbol exchangeSymbol = new ExchangeSymbol(symbol, name, date, isEnabled, type, iexId);
        Assertions.assertThat((String)exchangeSymbol.getSymbol()).isEqualTo((Object)symbol);
        Assertions.assertThat((String)exchangeSymbol.getName()).isEqualTo((Object)name);
        Assertions.assertThat((LocalDate)exchangeSymbol.getDate()).isEqualTo((Object)date);
        Assertions.assertThat((Boolean)exchangeSymbol.getEnabled()).isEqualTo((Object)isEnabled);
        Assertions.assertThat((Comparable)exchangeSymbol.getType()).isEqualTo((Object)type);
        Assertions.assertThat((Long)exchangeSymbol.getIexId()).isEqualTo((Object)iexId);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(ExchangeSymbol.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(ExchangeSymbol.class)).verify();
    }
}

