/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stats;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stats.Record;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class RecordTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal recordValue = (BigDecimal)this.fixture.create(BigDecimal.class);
        LocalDate recordDate = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal previousDayValue = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal avg30Value = (BigDecimal)this.fixture.create(BigDecimal.class);
        Record record = new Record(recordValue, recordDate, previousDayValue, avg30Value);
        Assertions.assertThat((BigDecimal)record.getRecordValue()).isEqualTo((Object)recordValue);
        Assertions.assertThat((LocalDate)record.getRecordDate()).isEqualTo((Object)recordDate);
        Assertions.assertThat((BigDecimal)record.getPreviousDayValue()).isEqualTo((Object)previousDayValue);
        Assertions.assertThat((BigDecimal)record.getAvg30Value()).isEqualTo((Object)avg30Value);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Record.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Record.class)).verify();
    }
}

