/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.BarData;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class BarDataTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        String symbol = (String)this.fixture.create(String.class);
        LocalDate date = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal open = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal high = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal low = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal close = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal volume = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal unadjustedVolume = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal change = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal changePercent = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal vwap = (BigDecimal)this.fixture.create(BigDecimal.class);
        BarData barData = new BarData(symbol, date, open, high, low, close, volume, unadjustedVolume, change, changePercent, vwap);
        Assertions.assertThat((String)barData.getSymbol()).isEqualTo((Object)symbol);
        Assertions.assertThat((LocalDate)barData.getDate()).isEqualTo((Object)date);
        Assertions.assertThat((BigDecimal)barData.getOpen()).isEqualTo((Object)open);
        Assertions.assertThat((BigDecimal)barData.getHigh()).isEqualTo((Object)high);
        Assertions.assertThat((BigDecimal)barData.getLow()).isEqualTo((Object)low);
        Assertions.assertThat((BigDecimal)barData.getClose()).isEqualTo((Object)close);
        Assertions.assertThat((BigDecimal)barData.getVolume()).isEqualTo((Object)volume);
        Assertions.assertThat((BigDecimal)barData.getUnadjustedVolume()).isEqualTo((Object)unadjustedVolume);
        Assertions.assertThat((BigDecimal)barData.getChange()).isEqualTo((Object)change);
        Assertions.assertThat((BigDecimal)barData.getChangePercent()).isEqualTo((Object)changePercent);
        Assertions.assertThat((BigDecimal)barData.getVwap()).isEqualTo((Object)vwap);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(BarData.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(BarData.class)).verify();
    }
}

