/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.marketdata.BookEntry;
import pl.zankowski.iextrading4j.api.marketdata.SystemEvent;
import pl.zankowski.iextrading4j.api.marketdata.Trade;
import pl.zankowski.iextrading4j.api.stocks.Book;
import pl.zankowski.iextrading4j.api.stocks.Quote;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class BookTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        Quote quote = (Quote)this.fixture.create(Quote.class);
        ArrayList bids = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(BookEntry.class, 2));
        ArrayList asks = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(BookEntry.class, 2));
        ArrayList trades = Lists.newArrayList((Iterable)this.fixture.collections().createCollection(Trade.class, 2));
        SystemEvent systemEvent = (SystemEvent)this.fixture.create(SystemEvent.class);
        Book book = new Book(quote, (List)bids, (List)asks, (List)trades, systemEvent);
        Assertions.assertThat((Object)book.getQuote()).isEqualTo((Object)quote);
        Assertions.assertThat((List)book.getBids()).isEqualTo((Object)bids);
        Assertions.assertThat((List)book.getAsks()).isEqualTo((Object)asks);
        Assertions.assertThat((List)book.getTrades()).isEqualTo((Object)trades);
        Assertions.assertThat((Object)book.getSystemEvent()).isEqualTo((Object)systemEvent);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Book.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Book.class)).verify();
    }
}

