/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import java.time.LocalDate;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.Earning;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class EarningTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal actualEPS = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal consensusEPS = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal estimatedEPS = (BigDecimal)this.fixture.create(BigDecimal.class);
        String announceTime = (String)this.fixture.create(String.class);
        BigDecimal numberOfEstimates = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal EPSSurpriseDollar = (BigDecimal)this.fixture.create(BigDecimal.class);
        LocalDate EPSReportDate = (LocalDate)this.fixture.create(LocalDate.class);
        String fiscalPeriod = (String)this.fixture.create(String.class);
        LocalDate fiscalEndDate = (LocalDate)this.fixture.create(LocalDate.class);
        BigDecimal yearAgo = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal yearAgoChangePercent = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal estimatedChangePercent = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal symbolId = (BigDecimal)this.fixture.create(BigDecimal.class);
        Earning earning = new Earning(actualEPS, consensusEPS, estimatedEPS, announceTime, numberOfEstimates, EPSSurpriseDollar, EPSReportDate, fiscalPeriod, fiscalEndDate, yearAgo, yearAgoChangePercent, estimatedChangePercent, symbolId);
        Assertions.assertThat((BigDecimal)earning.getActualEPS()).isEqualTo((Object)actualEPS);
        Assertions.assertThat((BigDecimal)earning.getConsensusEPS()).isEqualTo((Object)consensusEPS);
        Assertions.assertThat((BigDecimal)earning.getEstimatedEPS()).isEqualTo((Object)estimatedEPS);
        Assertions.assertThat((String)earning.getAnnounceTime()).isEqualTo((Object)announceTime);
        Assertions.assertThat((BigDecimal)earning.getNumberOfEstimates()).isEqualTo((Object)numberOfEstimates);
        Assertions.assertThat((BigDecimal)earning.getEPSSurpriseDollar()).isEqualTo((Object)EPSSurpriseDollar);
        Assertions.assertThat((LocalDate)earning.getEPSReportDate()).isEqualTo((Object)EPSReportDate);
        Assertions.assertThat((String)earning.getFiscalPeriod()).isEqualTo((Object)fiscalPeriod);
        Assertions.assertThat((LocalDate)earning.getFiscalEndDate()).isEqualTo((Object)fiscalEndDate);
        Assertions.assertThat((BigDecimal)earning.getYearAgo()).isEqualByComparingTo((Comparable)yearAgo);
        Assertions.assertThat((BigDecimal)earning.getYearAgoChangePercent()).isEqualByComparingTo((Comparable)yearAgoChangePercent);
        Assertions.assertThat((BigDecimal)earning.getEstimatedChangePercent()).isEqualByComparingTo((Comparable)estimatedChangePercent);
        Assertions.assertThat((BigDecimal)earning.getSymbolId()).isEqualByComparingTo((Comparable)symbolId);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(Earning.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(Earning.class)).verify();
    }
}

