/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.math.BigDecimal;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.EffectiveSpread;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class EffectiveSpreadTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        BigDecimal volume = (BigDecimal)this.fixture.create(BigDecimal.class);
        String venue = (String)this.fixture.create(String.class);
        String venueName = (String)this.fixture.create(String.class);
        BigDecimal effectiveSpread = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal effectiveQuoted = (BigDecimal)this.fixture.create(BigDecimal.class);
        BigDecimal priceImprovement = (BigDecimal)this.fixture.create(BigDecimal.class);
        EffectiveSpread spread = new EffectiveSpread(volume, venue, venueName, effectiveSpread, effectiveQuoted, priceImprovement);
        Assertions.assertThat((BigDecimal)spread.getVolume()).isEqualTo((Object)volume);
        Assertions.assertThat((String)spread.getVenue()).isEqualTo((Object)venue);
        Assertions.assertThat((String)spread.getVenueName()).isEqualTo((Object)venueName);
        Assertions.assertThat((BigDecimal)spread.getEffectiveSpread()).isEqualTo((Object)effectiveSpread);
        Assertions.assertThat((BigDecimal)spread.getEffectiveQuoted()).isEqualTo((Object)effectiveQuoted);
        Assertions.assertThat((BigDecimal)spread.getPriceImprovement()).isEqualTo((Object)priceImprovement);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(EffectiveSpread.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(EffectiveSpread.class)).verify();
    }
}

