/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.flextrade.jfixture.JFixture;
import java.time.OffsetDateTime;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.zankowski.iextrading4j.api.stocks.News;
import pl.zankowski.iextrading4j.api.util.ToStringVerifier;

public class NewsTest {
    private final JFixture fixture = new JFixture();

    @Test
    public void constructor() {
        OffsetDateTime datetime = (OffsetDateTime)this.fixture.create(OffsetDateTime.class);
        String headline = (String)this.fixture.create(String.class);
        String source = (String)this.fixture.create(String.class);
        String url = (String)this.fixture.create(String.class);
        String summary = (String)this.fixture.create(String.class);
        String related = (String)this.fixture.create(String.class);
        String image = (String)this.fixture.create(String.class);
        News news = new News(datetime, headline, source, url, summary, related, image);
        Assertions.assertThat((OffsetDateTime)news.getDatetime()).isEqualTo((Object)datetime);
        Assertions.assertThat((String)news.getHeadline()).isEqualTo((Object)headline);
        Assertions.assertThat((String)news.getSource()).isEqualTo((Object)source);
        Assertions.assertThat((String)news.getUrl()).isEqualTo((Object)url);
        Assertions.assertThat((String)news.getSummary()).isEqualTo((Object)summary);
        Assertions.assertThat((String)news.getRelated()).isEqualTo((Object)related);
        Assertions.assertThat((String)news.getImage()).isEqualTo((Object)image);
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(News.class).usingGetClass().verify();
    }

    @Test
    public void toStringVerification() {
        ToStringVerifier.forObject(this.fixture.create(News.class)).verify();
    }
}

